/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris.executor;

import com.ericsson.otp.erlang.OtpErlangException;
import de.zib.scalaris.RequestList;
import de.zib.scalaris.ResultList;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.executor.ScalarisOp;
import de.zib.scalaris.operations.WriteOp;

public class ScalarisWriteOp<T>
implements ScalarisOp {
    protected final String key;
    protected final T value;

    public ScalarisWriteOp(String key, T value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int workPhases() {
        return 1;
    }

    @Override
    public final int doPhase(int phase, int firstOp, ResultList results, RequestList requests) throws OtpErlangException, UnknownException, IllegalArgumentException {
        switch (phase) {
            case 0: {
                return this.prepareWrite(requests);
            }
            case 1: {
                return this.checkWrite(firstOp, results);
            }
        }
        throw new IllegalArgumentException("No phase " + phase);
    }

    protected int prepareWrite(RequestList requests) throws OtpErlangException, UnknownException {
        requests.addOp(new WriteOp(this.key, this.value));
        return 0;
    }

    protected int checkWrite(int firstOp, ResultList results) throws OtpErlangException, UnknownException {
        results.processWriteAt(firstOp);
        return 1;
    }

    @Override
    public String toString() {
        return "Scalaris.write(" + this.key + ", " + this.value + ")";
    }

    public String getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value;
    }
}

