/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris.executor;

import com.ericsson.otp.erlang.OtpErlangException;
import de.zib.scalaris.ErlangValue;
import de.zib.scalaris.NotFoundException;
import de.zib.scalaris.RequestList;
import de.zib.scalaris.ResultList;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.executor.ScalarisOp;
import de.zib.scalaris.operations.ReadOp;
import de.zib.scalaris.operations.WriteOp;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class ScalarisChangeListOp1
implements ScalarisOp {
    protected final String key;
    protected final String countKey;
    protected boolean listChanged = false;
    protected boolean listCountChanged = false;

    public ScalarisChangeListOp1(String key, String countKey) {
        this.key = key;
        this.countKey = countKey;
    }

    @Override
    public int workPhases() {
        return 2;
    }

    @Override
    public final int doPhase(int phase, int firstOp, ResultList results, RequestList requests) throws OtpErlangException, UnknownException, IllegalArgumentException {
        switch (phase) {
            case 0: {
                return this.prepareRead(requests);
            }
            case 1: {
                return this.prepareWrite(firstOp, results, requests);
            }
            case 2: {
                return this.checkWrite(firstOp, results);
            }
        }
        throw new IllegalArgumentException("No phase " + phase);
    }

    protected int prepareRead(RequestList requests) {
        requests.addOp(new ReadOp(this.key));
        return 0;
    }

    protected int prepareWrite(int firstOp, ResultList results, RequestList requests) throws OtpErlangException, UnknownException {
        List<ErlangValue> pageList;
        assert (results != null);
        try {
            pageList = results.processReadAt(firstOp).listValue();
        }
        catch (NotFoundException e) {
            pageList = new LinkedList<ErlangValue>();
        }
        pageList = this.changeList(pageList);
        if (this.listChanged) {
            requests.addOp(new WriteOp(this.key, pageList));
            if (this.countKey != null && this.listCountChanged) {
                requests.addOp(new WriteOp(this.countKey, pageList.size()));
            }
        }
        return 1;
    }

    protected abstract List<ErlangValue> changeList(List<ErlangValue> var1);

    protected int checkWrite(int firstOp, ResultList results) throws OtpErlangException, UnknownException {
        int checkedOps = 0;
        if (this.listChanged) {
            assert (results != null);
            results.processWriteAt(firstOp + checkedOps);
            ++checkedOps;
            if (this.countKey != null && this.listCountChanged) {
                results.processWriteAt(firstOp + checkedOps);
                ++checkedOps;
            }
        }
        return checkedOps;
    }

    protected static <T> List<ErlangValue> toErlangValueList(List<T> list) throws ClassCastException {
        ArrayList<ErlangValue> result = new ArrayList<ErlangValue>(list.size());
        for (T t : list) {
            result.add(new ErlangValue(t));
        }
        return result;
    }
}

