/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import de.zib.scalaris.Connection;
import de.zib.scalaris.ConnectionException;
import de.zib.scalaris.ConnectionFactory;
import de.zib.scalaris.ErlangValue;
import de.zib.scalaris.FixedNodeConnectionPolicy;
import de.zib.scalaris.UnknownException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Monitor {
    private final Connection connection;

    public Monitor(String node) throws ConnectionException {
        ConnectionFactory cf = ConnectionFactory.getInstance();
        String fixedNode = ConnectionFactory.fixLocalhostName(node);
        this.connection = cf.createConnection(new FixedNodeConnectionPolicy(fixedNode));
    }

    public GetNodeInfoResult getNodeInfo() throws ConnectionException, UnknownException {
        OtpErlangObject received_raw = this.connection.doRPC("api_monitor", "get_node_info", new OtpErlangObject[0]);
        try {
            OtpErlangList received = (OtpErlangList)received_raw;
            LinkedHashMap<String, OtpErlangObject> result = new LinkedHashMap<String, OtpErlangObject>(received.arity());
            for (OtpErlangObject iter : received) {
                OtpErlangTuple iter_tpl = (OtpErlangTuple)iter;
                if (iter_tpl.arity() == 2) {
                    String key = ((OtpErlangAtom)iter_tpl.elementAt(0)).atomValue();
                    result.put(key, iter_tpl.elementAt(1));
                    continue;
                }
                throw new UnknownException(received_raw);
            }
            String scalarisVersion = new ErlangValue((OtpErlangObject)result.get("scalaris_version")).stringValue();
            String erlangVersion = new ErlangValue((OtpErlangObject)result.get("erlang_version")).stringValue();
            int dhtNodes = new ErlangValue((OtpErlangObject)result.get("dht_nodes")).intValue();
            return new GetNodeInfoResult(scalarisVersion, erlangVersion, dhtNodes);
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
        catch (NullPointerException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    public GetNodePerformanceResult getNodePerformance() throws ConnectionException, UnknownException {
        OtpErlangObject received_raw = this.connection.doRPC("api_monitor", "get_node_performance", new OtpErlangObject[0]);
        try {
            OtpErlangList received = (OtpErlangList)received_raw;
            LinkedHashMap<String, OtpErlangObject> result = new LinkedHashMap<String, OtpErlangObject>(received.arity());
            for (OtpErlangObject iter : received) {
                OtpErlangTuple iter_tpl = (OtpErlangTuple)iter;
                if (iter_tpl.arity() == 2) {
                    String key = ((OtpErlangAtom)iter_tpl.elementAt(0)).atomValue();
                    result.put(key, iter_tpl.elementAt(1));
                    continue;
                }
                throw new UnknownException(received_raw);
            }
            Map<Long, Double> latencyAvg = Monitor.tupleListToLDMap((OtpErlangObject)result.get("latency_avg"));
            Map<Long, Double> latencyStddev = Monitor.tupleListToLDMap((OtpErlangObject)result.get("latency_stddev"));
            return new GetNodePerformanceResult(latencyAvg, latencyStddev);
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
        catch (NullPointerException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    public GetServiceInfoResult getServiceInfo() throws ConnectionException, UnknownException {
        OtpErlangObject received_raw = this.connection.doRPC("api_monitor", "get_service_info", new OtpErlangObject[0]);
        try {
            OtpErlangList received = (OtpErlangList)received_raw;
            LinkedHashMap<String, OtpErlangObject> result = new LinkedHashMap<String, OtpErlangObject>(received.arity());
            for (OtpErlangObject iter : received) {
                OtpErlangTuple iter_tpl = (OtpErlangTuple)iter;
                if (iter_tpl.arity() == 2) {
                    String key = ((OtpErlangAtom)iter_tpl.elementAt(0)).atomValue();
                    result.put(key, iter_tpl.elementAt(1));
                    continue;
                }
                throw new UnknownException(received_raw);
            }
            Long totalLoad = new ErlangValue((OtpErlangObject)result.get("total_load")).longValue();
            Long nodes = new ErlangValue((OtpErlangObject)result.get("nodes")).longValue();
            return new GetServiceInfoResult(totalLoad, nodes);
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
        catch (NullPointerException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    public GetServicePerformanceResult getServicePerformance() throws ConnectionException, UnknownException {
        OtpErlangObject received_raw = this.connection.doRPC("api_monitor", "get_service_performance", new OtpErlangObject[0]);
        try {
            OtpErlangList received = (OtpErlangList)received_raw;
            LinkedHashMap<String, OtpErlangObject> result = new LinkedHashMap<String, OtpErlangObject>(received.arity());
            for (OtpErlangObject iter : received) {
                OtpErlangTuple iter_tpl = (OtpErlangTuple)iter;
                if (iter_tpl.arity() == 2) {
                    String key = ((OtpErlangAtom)iter_tpl.elementAt(0)).atomValue();
                    result.put(key, iter_tpl.elementAt(1));
                    continue;
                }
                throw new UnknownException(received_raw);
            }
            Map<Long, Double> latencyAvg = Monitor.tupleListToLDMap((OtpErlangObject)result.get("latency_avg"));
            Map<Long, Double> latencyStddev = Monitor.tupleListToLDMap((OtpErlangObject)result.get("latency_stddev"));
            return new GetServicePerformanceResult(latencyAvg, latencyStddev);
        }
        catch (ClassCastException e) {
            throw new UnknownException(e, received_raw);
        }
        catch (NullPointerException e) {
            throw new UnknownException(e, received_raw);
        }
    }

    private static <K, V> Map<K, V> tupleListToMap(OtpErlangObject object, ErlangValue.ListElementConverter<K> keyConv, ErlangValue.ListElementConverter<V> valConv) throws ClassCastException {
        OtpErlangList list = ErlangValue.otpObjectToOtpList(object);
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>(list.arity());
        for (int i = 0; i < list.arity(); ++i) {
            OtpErlangTuple element = (OtpErlangTuple)list.elementAt(i);
            if (element.arity() != 2) {
                throw new ClassCastException("wrong tuple arity");
            }
            K key = keyConv.convert(i, new ErlangValue(element.elementAt(0)));
            V value = valConv.convert(i, new ErlangValue(element.elementAt(1)));
            result.put(key, value);
        }
        return result;
    }

    private static Map<Long, Double> tupleListToLDMap(OtpErlangObject object) throws ClassCastException {
        return Monitor.tupleListToMap(object, new ErlangValue.ListElementConverter<Long>(){

            @Override
            public Long convert(int i, ErlangValue v) {
                return v.longValue();
            }
        }, new ErlangValue.ListElementConverter<Double>(){

            @Override
            public Double convert(int i, ErlangValue v) {
                return v.doubleValue();
            }
        });
    }

    public void closeConnection() {
        this.connection.close();
    }

    public static Double getCurrentPerfValue(Map<Long, Double> map) {
        Set<Map.Entry<Long, Double>> entrySet = map.entrySet();
        if (entrySet.isEmpty()) {
            return null;
        }
        return entrySet.iterator().next().getValue();
    }

    public static class GetServicePerformanceResult {
        public final Map<Long, Double> latencyAvg;
        public final Map<Long, Double> latencyStddev;

        public GetServicePerformanceResult(Map<Long, Double> latencyAvg, Map<Long, Double> latencyStddev) {
            this.latencyAvg = latencyAvg;
            this.latencyStddev = latencyStddev;
        }
    }

    public static class GetServiceInfoResult {
        public final Long totalLoad;
        public final Long nodes;

        public GetServiceInfoResult(Long totalLoad, Long nodes) {
            this.totalLoad = totalLoad;
            this.nodes = nodes;
        }
    }

    public static class GetNodePerformanceResult {
        public final Map<Long, Double> latencyAvg;
        public final Map<Long, Double> latencyStddev;

        public GetNodePerformanceResult(Map<Long, Double> latencyAvg, Map<Long, Double> latencyStddev) {
            this.latencyAvg = latencyAvg;
            this.latencyStddev = latencyStddev;
        }
    }

    public static class GetNodeInfoResult {
        public final String scalarisVersion;
        public final String erlangVersion;
        public final int dhtNodes;

        public GetNodeInfoResult(String scalarisVersion, String erlangVersion, int dhtNodes) {
            this.scalarisVersion = scalarisVersion;
            this.erlangVersion = erlangVersion;
            this.dhtNodes = dhtNodes;
        }
    }
}

