/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangDouble;
import com.ericsson.otp.erlang.OtpErlangInt;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import de.zib.scalaris.CommonErlangObjects;
import de.zib.scalaris.ErlangValue;
import java.math.BigInteger;
import java.util.List;

abstract class ErlangValueJSONBase {
    ErlangValueJSONBase() {
    }

    protected abstract OtpErlangTuple convertJavaToScalarisJSON_object(Object var1) throws ClassCastException;

    protected OtpErlangObject convertJavaToScalarisJSON_value(Object value) throws ClassCastException {
        if (value == null) {
            return CommonErlangObjects.nullAtom;
        }
        if (value instanceof Integer) {
            return new OtpErlangInt(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new OtpErlangLong(((Long)value).longValue());
        }
        if (value instanceof BigInteger) {
            return new OtpErlangLong((BigInteger)value);
        }
        if (value instanceof Double) {
            return new OtpErlangDouble(((Double)value).doubleValue());
        }
        if (value instanceof String) {
            return new OtpErlangString((String)value);
        }
        if (value instanceof List) {
            List list = (List)value;
            return this.convertJavaToScalarisJSON_array(list);
        }
        if (value.equals(true)) {
            return CommonErlangObjects.trueAtom;
        }
        if (value.equals(false)) {
            return CommonErlangObjects.falseAtom;
        }
        return this.convertJavaToScalarisJSON_object(value);
    }

    protected OtpErlangTuple convertJavaToScalarisJSON_array(List<Object> value) throws ClassCastException {
        OtpErlangObject[] resultList = new OtpErlangObject[value.size()];
        int i = 0;
        for (Object iter : value) {
            resultList[i] = this.convertJavaToScalarisJSON_value(iter);
            ++i;
        }
        OtpErlangTuple resultTpl = new OtpErlangTuple(new OtpErlangObject[]{CommonErlangObjects.arrayAtom, new OtpErlangList(resultList)});
        return resultTpl;
    }

    protected Object convertScalarisJSONtoJava_value_simple(OtpErlangObject value) throws ClassCastException {
        if (value instanceof OtpErlangLong) {
            OtpErlangLong value_int = (OtpErlangLong)value;
            try {
                return value_int.intValue();
            }
            catch (OtpErlangRangeException e) {
                if (value_int.isLong()) {
                    return value_int.longValue();
                }
                return value_int.bigIntegerValue();
            }
        }
        if (value instanceof OtpErlangDouble) {
            return ((OtpErlangDouble)value).doubleValue();
        }
        if (value instanceof OtpErlangString) {
            return ((OtpErlangString)value).stringValue();
        }
        if (value instanceof OtpErlangList) {
            try {
                return ErlangValue.otpObjectToString(value);
            }
            catch (ClassCastException e) {
                throw new ClassCastException("Unsupported JSON type (value: " + value.toString() + ")");
            }
        }
        if (value.equals((Object)CommonErlangObjects.trueAtom)) {
            return true;
        }
        if (value.equals((Object)CommonErlangObjects.falseAtom)) {
            return false;
        }
        if (value.equals((Object)CommonErlangObjects.nullAtom)) {
            return null;
        }
        throw new ClassCastException("Unsupported JSON type (value: " + value.toString() + ")");
    }

    protected String convertScalarisJSONtoJava_key(OtpErlangObject key_erl) throws ClassCastException {
        if (key_erl instanceof OtpErlangAtom) {
            return ((OtpErlangAtom)key_erl).atomValue();
        }
        try {
            return ErlangValue.otpObjectToString(key_erl);
        }
        catch (ClassCastException e) {
            throw new ClassCastException("Unsupported JSON key (" + key_erl.toString() + "): " + e.getMessage());
        }
    }
}

