/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import de.zib.scalaris.Connection;
import de.zib.scalaris.ConnectionException;
import de.zib.scalaris.ConnectionFactory;
import de.zib.scalaris.PeerNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class ConnectionPool {
    protected ConnectionFactory cFactory;
    protected int maxConnections;
    protected LinkedList<Connection> availableConns;
    protected int checkedOut = 0;

    public ConnectionPool(ConnectionFactory cFactory, int maxConnections) {
        this.cFactory = cFactory;
        this.maxConnections = maxConnections;
        this.availableConns = new LinkedList();
    }

    public synchronized Connection getConnection() throws ConnectionException {
        Connection conn = null;
        if (!this.availableConns.isEmpty()) {
            conn = this.availableConns.remove();
            ++this.checkedOut;
        } else if (this.maxConnections == 0 || this.checkedOut < this.maxConnections) {
            conn = this.cFactory.createConnection();
            ++this.checkedOut;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(long timeout) throws ConnectionException {
        Connection conn;
        long timeAtStart = System.currentTimeMillis();
        while ((conn = this.getConnection()) == null) {
            long timeAtEnd;
            try {
                ConnectionPool connectionPool = this;
                synchronized (connectionPool) {
                    this.wait(timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((timeAtEnd = System.currentTimeMillis()) - timeAtStart < timeout) continue;
            return null;
        }
        return conn;
    }

    public synchronized void releaseConnection(Connection conn) {
        this.availableConns.add(conn);
        --this.checkedOut;
        this.notifyAll();
    }

    public synchronized void closeAll() {
        for (Connection conn : this.availableConns) {
            conn.close();
        }
        this.availableConns.clear();
    }

    public synchronized void closeAllBut(Collection<PeerNode> remainingNodes) {
        Iterator iterator = this.availableConns.iterator();
        while (iterator.hasNext()) {
            Connection conn = (Connection)iterator.next();
            if (remainingNodes.contains(conn.getRemote())) continue;
            conn.close();
            iterator.remove();
        }
    }

    protected void finalize() throws Throwable {
        this.closeAll();
        super.finalize();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.cFactory;
    }
}

