/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpErlangBinary;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import de.zib.scalaris.Connection;
import de.zib.scalaris.ConnectionFactory;
import de.zib.scalaris.PeerNode;
import de.zib.scalaris.RoundRobinConnectionPolicy;
import de.zib.scalaris.Transaction;
import de.zib.scalaris.TransactionSingleOp;
import de.zib.scalaris.operations.AddDelOnListOp;
import de.zib.scalaris.operations.AddOnNrOp;
import de.zib.scalaris.operations.ReadOp;
import de.zib.scalaris.operations.WriteOp;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class Benchmark {
    protected static final int BENCH_DATA_SIZE = 1000;
    protected static final long benchTime = System.currentTimeMillis();
    protected static final int percentToRemove = 5;
    protected static final int testRuns = 1;
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static void minibench(int operations, int threadsPerNode, Set<Integer> benchmarks) {
        ConnectionFactory cf = ConnectionFactory.getInstance();
        List<PeerNode> nodes = cf.getNodes();
        int parallelRuns = nodes.size() * threadsPerNode;
        cf.setConnectionPolicy(new RoundRobinConnectionPolicy(nodes));
        System.out.println("Number of available nodes: " + nodes.size());
        System.out.println("-> Using " + parallelRuns + " parallel instances per test run...");
        System.out.flush();
        System.out.println("Benchmark of de.zib.scalaris.TransactionSingleOp:");
        System.out.flush();
        long[][] results = Benchmark.getResultArray(3, 2);
        Class[] testTypes = new Class[]{OtpErlangBinary.class, String.class};
        String[] testTypesStr = new String[]{"OEB", "S"};
        String[] columns = new String[]{"TransactionSingleOp.write(OtpErlangString, OtpErlangBinary)", "TransactionSingleOp.write(String, String)"};
        Class[] testBench = new Class[]{TransSingleOpBench1.class, TransSingleOpBench2.class, TransSingleOpBench3.class};
        String[] rows = new String[]{"separate connection", "re-use connection", "re-use object"};
        String testGroup = "transsinglebench";
        Benchmark.runBenchAndPrintResults(benchmarks, results, columns, rows, testTypes, testTypesStr, testBench, testGroup, 1, operations, parallelRuns);
        System.out.println("-----");
        System.out.println("Benchmark of de.zib.scalaris.Transaction:");
        System.out.flush();
        results = Benchmark.getResultArray(3, 2);
        testTypes = new Class[]{OtpErlangBinary.class, String.class};
        testTypesStr = new String[]{"OEB", "S"};
        columns = new String[]{"Transaction.write(OtpErlangString, OtpErlangBinary)", "Transaction.write(String, String)"};
        testBench = new Class[]{TransBench1.class, TransBench2.class, TransBench3.class};
        rows = new String[]{"separate connection", "re-use connection", "re-use object"};
        testGroup = "transbench";
        Benchmark.runBenchAndPrintResults(benchmarks, results, columns, rows, testTypes, testTypesStr, testBench, testGroup, 1, operations, parallelRuns);
        System.out.println("-----");
        System.out.println("Benchmark incrementing an integer key (read+write):");
        System.out.flush();
        results = Benchmark.getResultArray(3, 1);
        testTypes = new Class[]{null};
        testTypesStr = new String[]{"null"};
        columns = new String[]{"Transaction.addOnNr(String, Integer)"};
        testBench = new Class[]{TransIncrementBench1.class, TransIncrementBench2.class, TransIncrementBench3.class};
        rows = new String[]{"separate connection", "re-use connection", "re-use object"};
        testGroup = "transbench_inc";
        Benchmark.runBenchAndPrintResults(benchmarks, results, columns, rows, testTypes, testTypesStr, testBench, testGroup, 7, operations, parallelRuns);
        System.out.println("-----");
        System.out.println("Benchmark read 5 + write 5:");
        System.out.flush();
        results = Benchmark.getResultArray(3, 2);
        testTypes = new Class[]{OtpErlangBinary.class, String.class};
        testTypesStr = new String[]{"OEB", "S"};
        columns = new String[]{"Transaction.read(OtpErlangString) + Transaction.write(OtpErlangString, OtpErlangBinary)", "Transaction.read(String) + Transaction.write(String, String)"};
        testBench = new Class[]{TransRead5Write5Bench1.class, TransRead5Write5Bench2.class, TransRead5Write5Bench3.class};
        rows = new String[]{"separate connection", "re-use connection", "re-use object"};
        testGroup = "transbench_r5w5";
        Benchmark.runBenchAndPrintResults(benchmarks, results, columns, rows, testTypes, testTypesStr, testBench, testGroup, 10, operations, parallelRuns);
        System.out.println("-----");
        System.out.println("Benchmark appending to a String list (read+write):");
        System.out.flush();
        results = Benchmark.getResultArray(3, 1);
        testTypes = new Class[]{String.class};
        testTypesStr = new String[]{"S"};
        columns = new String[]{"Transaction.addDelOnList(String, StringList, [])"};
        testBench = new Class[]{TransAppendToListBench1.class, TransAppendToListBench2.class, TransAppendToListBench3.class};
        rows = new String[]{"separate connection", "re-use connection", "re-use object"};
        testGroup = "transbench_append";
        Benchmark.runBenchAndPrintResults(benchmarks, results, columns, rows, testTypes, testTypesStr, testBench, testGroup, 16, operations, parallelRuns);
    }

    protected static long[][] getResultArray(int rows, int columns) {
        long[][] results = new long[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                results[i][j] = -1L;
            }
        }
        return results;
    }

    public static <T> T getRandom(int size, Class<T> c) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return Benchmark.getRandom(size, c, new Random());
    }

    public static <T> T getRandom(int size, Class<T> c, Random r) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (c == null) {
            return null;
        }
        if (Integer.class.isAssignableFrom(c)) {
            int par = r.nextInt();
            return c.getConstructor(Integer.TYPE).newInstance(par);
        }
        byte[] data = new byte[size];
        r.nextBytes(data);
        try {
            if (!String.class.isAssignableFrom(c)) {
                return c.getConstructor(byte[].class).newInstance(new Object[]{data});
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        CharsetDecoder decoder = UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        try {
            String par = decoder.decode(ByteBuffer.wrap(data)).toString();
            return c.getConstructor(String.class).newInstance(par);
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static <T> int integrateResults(long[] results, int i, BenchRunnable<T>[] worker, int failed) {
        for (BenchRunnable<T> benchThread : worker) {
            long speed;
            if (failed >= 3) {
                benchThread.stop = true;
                try {
                    benchThread.join();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                benchThread.join();
                speed = benchThread.getSpeed();
            }
            catch (InterruptedException e) {
                speed = -1L;
            }
            if (speed < 0L) {
                ++failed;
                continue;
            }
            int n = i;
            results[n] = results[n] + speed;
        }
        return failed;
    }

    protected static long getAvgSpeed(long[] results) {
        Arrays.sort(results);
        int toRemove = results.length * 5 / 100;
        long avgSpeed = 0L;
        for (int i = toRemove; i < results.length - toRemove; ++i) {
            avgSpeed += results[i];
        }
        return avgSpeed /= (long)(results.length - 2 * toRemove);
    }

    protected static void runBenchAndPrintResults(Set<Integer> benchmarks, long[][] results, String[] columns, String[] rows, Class[] testTypes, String[] testTypesStr, Class[] testBench, String testGroup, int firstBenchId, int operations, int parallelRuns) {
        for (int test = 0; test < results.length * results[0].length; ++test) {
            try {
                int i = test % results.length;
                int j = test / results.length;
                if (benchmarks.contains(test + firstBenchId)) {
                    results[i][j] = Benchmark.runBench(operations, Benchmark.getRandom(1000, testTypes[j]), testGroup + "_" + testTypesStr[j] + "_" + (i + 1), testBench[i], parallelRuns);
                    TimeUnit.SECONDS.sleep(1L);
                    continue;
                }
                results[i][j] = -2L;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Benchmark.printResults(columns, rows, results, operations, parallelRuns);
    }

    protected static <T> long runBench(int operations, T value, String name, Class<? extends BenchRunnable> clazz, int parallelRuns) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String key = benchTime + name;
        long[] results = new long[1];
        Arrays.fill(results, -1L);
        for (int i = 0; i < 1; ++i) {
            BenchRunnable[] worker = new BenchRunnable[parallelRuns];
            for (int thread = 0; thread < parallelRuns; ++thread) {
                Class valueClazz = value == null ? Object.class : value.getClass();
                try {
                    worker[thread] = clazz.getConstructor(String.class, valueClazz, Integer.TYPE).newInstance(key + '_' + i + '_' + thread, value, operations);
                }
                catch (NoSuchMethodException e) {
                    worker[thread] = clazz.getConstructor(String.class, Object.class, Integer.TYPE).newInstance(key + '_' + i + '_' + thread, value, operations);
                }
                worker[thread].start();
            }
            int failed = 0;
            if ((failed = Benchmark.integrateResults(results, i, worker, failed)) < 3) continue;
            return -1L;
        }
        return Benchmark.getAvgSpeed(results);
    }

    protected static void printResults(String[] columns, String[] rows, long[][] results, int operations, int parallelRuns) {
        int i;
        System.out.println("Concurrent threads: " + parallelRuns + ", each using " + operations + " transactions");
        System.out.println("                         \tspeed (transactions / second)");
        String firstColumn = "                         ";
        System.out.print("                         ");
        for (i = 0; i < columns.length; ++i) {
            System.out.print("\t(" + (i + 1) + ")");
        }
        System.out.println();
        for (i = 0; i < rows.length; ++i) {
            System.out.print(rows[i] + "                         ".substring(0, "                         ".length() - rows[i].length() - 1));
            for (int j = 0; j < columns.length; ++j) {
                if (results[i][j] == -2L) {
                    System.out.print("\tn/a");
                    continue;
                }
                if (results[i][j] == -1L) {
                    System.out.print("\tfailed");
                    continue;
                }
                System.out.print("\t" + results[i][j]);
            }
            System.out.println();
        }
        for (i = 0; i < columns.length; ++i) {
            System.out.println("(" + (i + 1) + ") " + columns[i]);
        }
    }

    protected static abstract class BenchRunnable2<T>
    extends BenchRunnable<T> {
        protected Connection connection;

        protected BenchRunnable2(String key, T value, int operations) {
            super(key, value, operations);
        }

        @Override
        protected void init() throws Exception {
            this.connection = ConnectionFactory.getInstance().createConnection();
        }

        @Override
        protected void cleanup() throws Exception {
            this.connection.close();
        }
    }

    protected static abstract class BenchRunnable<T>
    extends Thread {
        public boolean stop = false;
        private long timeAtStart = 0L;
        private long speed = -1L;
        protected final String key;
        protected final T value;
        protected int operations;

        public BenchRunnable(String key, T value, int operations) {
            this.key = key;
            this.value = value;
            this.operations = operations;
        }

        private final void testBegin() {
            this.timeAtStart = System.currentTimeMillis();
        }

        private final long testEnd(int testRuns) {
            long timeTaken = System.currentTimeMillis() - this.timeAtStart;
            long speed = (long)(testRuns * 1000) / timeTaken;
            return speed;
        }

        protected void pre_init(Connection conn) throws Exception {
        }

        protected void pre_init(Connection conn, int j) throws Exception {
        }

        protected void init() throws Exception {
        }

        protected void cleanup() throws Exception {
        }

        protected abstract void operation(int var1) throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Thread.currentThread().setName("BenchRunnable-" + this.key);
            Connection conn = null;
            try {
                conn = ConnectionFactory.getInstance().createConnection();
                for (int retry = 0; retry < 3 && !this.stop; ++retry) {
                    try {
                        int j;
                        this.pre_init(conn);
                        for (j = 0; j < this.operations; ++j) {
                            this.pre_init(conn, j);
                        }
                        this.testBegin();
                        this.init();
                        for (j = 0; j < this.operations; ++j) {
                            this.operation(j);
                        }
                        this.cleanup();
                        this.speed = this.testEnd(this.operations);
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }

        public long getSpeed() {
            return this.speed;
        }
    }

    protected static final class TransAppendToListBench3
    extends TransAppendToListBench {
        Transaction transaction;

        public TransAppendToListBench3(String key, String value, int operations) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            super(key, value, 5, operations);
        }

        @Override
        protected void init() throws Exception {
            this.transaction = new Transaction();
        }

        @Override
        protected void cleanup() throws Exception {
            this.transaction.closeConnection();
        }

        @Override
        protected void operation(int j) throws Exception {
            this.operation(this.transaction, j);
        }
    }

    protected static final class TransAppendToListBench2
    extends TransAppendToListBench {
        protected Connection connection;

        public TransAppendToListBench2(String key, String value, int operations) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            super(key, value, 5, operations);
        }

        @Override
        protected void init() throws Exception {
            this.connection = ConnectionFactory.getInstance().createConnection();
        }

        @Override
        protected void cleanup() throws Exception {
            this.connection.close();
        }

        @Override
        protected void operation(int j) throws Exception {
            Transaction tx = new Transaction(this.connection);
            this.operation(tx, j);
        }
    }

    protected static final class TransAppendToListBench1
    extends TransAppendToListBench {
        public TransAppendToListBench1(String key, String value, int operations) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            super(key, value, 5, operations);
        }

        @Override
        protected void operation(int j) throws Exception {
            Transaction tx = new Transaction();
            this.operation(tx, j);
            tx.closeConnection();
        }
    }

    protected static abstract class TransAppendToListBench
    extends BenchRunnable<String> {
        private final List<String> valueInit;

        public TransAppendToListBench(String key, String value, int nrKeys, int operations) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            super(key, value, operations);
            this.valueInit = new ArrayList<String>(nrKeys);
            for (int i = 0; i < nrKeys; ++i) {
                this.valueInit.add(Benchmark.getRandom(1000, String.class));
            }
        }

        @Override
        protected void pre_init(Connection conn, int j) throws Exception {
            Transaction tx_init = new Transaction(conn);
            Transaction.RequestList reqs = new Transaction.RequestList();
            reqs.addOp(new WriteOp(this.key + '_' + j, this.valueInit)).addCommit();
            Transaction.ResultList results = tx_init.req_list(reqs);
            results.processWriteAt(0);
        }

        protected void operation(Transaction tx, int j) throws Exception {
            Transaction.RequestList reqs = new Transaction.RequestList();
            reqs.addOp(new AddDelOnListOp(this.key + '_' + j, Arrays.asList((String)this.value), new ArrayList(0)));
            reqs.addCommit();
            Transaction.ResultList results = tx.req_list(reqs);
            results.processAddDelOnListAt(0);
        }
    }

    protected static final class TransRead5Write5Bench3<T>
    extends TransReadXWriteXBench<T> {
        Transaction transaction;

        public TransRead5Write5Bench3(String key, T value, int operations) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            super(key, value, 5, operations);
        }

        @Override
        protected void init() throws Exception {
            this.transaction = new Transaction();
        }

        @Override
        protected void cleanup() throws Exception {
            this.transaction.closeConnection();
        }

        @Override
        protected void operation(int j) throws Exception {
            this.operation(this.transaction, j);
        }
    }

    protected static final class TransRead5Write5Bench2<T>
    extends TransReadXWriteXBench<T> {
        protected Connection connection;

        public TransRead5Write5Bench2(String key, T value, int operations) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            super(key, value, 5, operations);
        }

        @Override
        protected void init() throws Exception {
            this.connection = ConnectionFactory.getInstance().createConnection();
        }

        @Override
        protected void cleanup() throws Exception {
            this.connection.close();
        }

        @Override
        protected void operation(int j) throws Exception {
            Transaction tx = new Transaction(this.connection);
            this.operation(tx, j);
        }
    }

    protected static final class TransRead5Write5Bench1<T>
    extends TransReadXWriteXBench<T> {
        public TransRead5Write5Bench1(String key, T value, int operations) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            super(key, value, 5, operations);
        }

        @Override
        protected void operation(int j) throws Exception {
            Transaction tx = new Transaction();
            this.operation(tx, j);
            tx.closeConnection();
        }
    }

    protected static abstract class TransReadXWriteXBench<T>
    extends BenchRunnable<T> {
        private final String[] keys;
        private final T[] valueWrite;

        public TransReadXWriteXBench(String key, T value, int nrKeys, int operations) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            super(key, value, operations);
            this.keys = new String[nrKeys];
            this.valueWrite = (Object[])Array.newInstance(value.getClass(), nrKeys);
            for (int i = 0; i < this.keys.length; ++i) {
                this.keys[i] = key + "_" + i;
                this.valueWrite[i] = Benchmark.getRandom(1000, value.getClass());
            }
        }

        @Override
        protected void pre_init(Connection conn) throws Exception {
            Object[] valueInit = (Object[])Array.newInstance(this.value.getClass(), this.keys.length);
            for (int i = 0; i < this.keys.length; ++i) {
                valueInit[i] = Benchmark.getRandom(1000, this.value.getClass());
            }
            Transaction tx_init = new Transaction(conn);
            Transaction.RequestList reqs = new Transaction.RequestList();
            for (int i = 0; i < this.keys.length; ++i) {
                reqs.addOp(new WriteOp(this.keys[i], valueInit[i]));
            }
            reqs.addCommit();
            Transaction.ResultList results = tx_init.req_list(reqs);
            for (int i = 0; i < this.keys.length; ++i) {
                results.processWriteAt(i);
            }
        }

        protected void operation(Transaction tx, int j) throws Exception {
            Transaction.RequestList reqs = new Transaction.RequestList();
            for (String key : this.keys) {
                if (this.value instanceof OtpErlangObject) {
                    reqs.addOp(new ReadOp(new OtpErlangString(key)));
                    continue;
                }
                reqs.addOp(new ReadOp(key));
            }
            reqs.addCommit();
            Transaction.ResultList results = tx.req_list(reqs);
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.value instanceof OtpErlangObject) {
                    results.processReadAt(i);
                    continue;
                }
                results.processReadAt(i).stringValue();
            }
            reqs = new Transaction.RequestList();
            for (String key : this.keys) {
                T value = this.valueWrite[j % this.valueWrite.length];
                if (value instanceof OtpErlangObject) {
                    reqs.addOp(new WriteOp(new OtpErlangString(key), (OtpErlangObject)value));
                    continue;
                }
                reqs.addOp(new WriteOp(key, value));
            }
            reqs.addCommit();
            results = tx.req_list(reqs);
            for (int i = 0; i < this.keys.length; ++i) {
                results.processWriteAt(i);
            }
        }
    }

    protected static final class TransIncrementBench3
    extends TransIncrementBench {
        Transaction transaction;

        public TransIncrementBench3(String key, Object value, int operations) {
            super(key, value, operations);
        }

        @Override
        protected void init() throws Exception {
            this.transaction = new Transaction();
        }

        @Override
        protected void cleanup() throws Exception {
            this.transaction.closeConnection();
        }

        @Override
        protected void operation(int j) throws Exception {
            this.operation(this.transaction, j);
        }
    }

    protected static final class TransIncrementBench2
    extends TransIncrementBench {
        protected Connection connection;

        public TransIncrementBench2(String key, Object value, int operations) {
            super(key, value, operations);
        }

        @Override
        protected void init() throws Exception {
            this.connection = ConnectionFactory.getInstance().createConnection();
        }

        @Override
        protected void cleanup() throws Exception {
            this.connection.close();
        }

        @Override
        protected void operation(int j) throws Exception {
            Transaction transaction = new Transaction(this.connection);
            this.operation(transaction, j);
        }
    }

    protected static final class TransIncrementBench1
    extends TransIncrementBench {
        public TransIncrementBench1(String key, Object value, int operations) {
            super(key, value, operations);
        }

        @Override
        protected void operation(int j) throws Exception {
            Transaction transaction = new Transaction();
            this.operation(transaction, j);
            transaction.closeConnection();
        }
    }

    protected static abstract class TransIncrementBench
    extends BenchRunnable<Object> {
        public TransIncrementBench(String key, Object value, int operations) {
            super(key, value, operations);
        }

        @Override
        protected void pre_init(Connection conn) throws Exception {
            Transaction tx_init = new Transaction(conn);
            tx_init.write(this.key, 0);
            tx_init.commit();
        }

        protected void operation(Transaction tx, int j) throws Exception {
            Transaction.RequestList reqs = new Transaction.RequestList();
            reqs.addOp(new AddOnNrOp(this.key, 1)).addCommit();
            Transaction.ResultList results = tx.req_list(reqs);
            results.processAddOnNrAt(0);
        }
    }

    protected static final class TransBench3<T>
    extends BenchRunnable<T> {
        Transaction transaction;

        public TransBench3(String key, T value, int operations) {
            super(key, value, operations);
        }

        @Override
        protected void init() throws Exception {
            this.transaction = new Transaction();
        }

        @Override
        protected void cleanup() throws Exception {
            this.transaction.closeConnection();
        }

        @Override
        protected void operation(int j) throws Exception {
            if (this.value instanceof OtpErlangObject) {
                this.transaction.write(new OtpErlangString(this.key + '_' + j), (OtpErlangObject)this.value);
            } else {
                this.transaction.write(this.key + '_' + j, this.value);
            }
            this.transaction.commit();
        }
    }

    protected static final class TransBench2<T>
    extends BenchRunnable2<T> {
        public TransBench2(String key, T value, int operations) {
            super(key, value, operations);
        }

        @Override
        protected void operation(int j) throws Exception {
            Transaction transaction = new Transaction(this.connection);
            if (this.value instanceof OtpErlangObject) {
                transaction.write(new OtpErlangString(this.key + '_' + j), (OtpErlangObject)this.value);
            } else {
                transaction.write(this.key + '_' + j, this.value);
            }
            transaction.commit();
        }
    }

    protected static final class TransBench1<T>
    extends BenchRunnable<T> {
        public TransBench1(String key, T value, int operations) {
            super(key, value, operations);
        }

        @Override
        protected void operation(int j) throws Exception {
            Transaction transaction = new Transaction();
            if (this.value instanceof OtpErlangObject) {
                transaction.write(new OtpErlangString(this.key + '_' + j), (OtpErlangObject)this.value);
            } else {
                transaction.write(this.key + '_' + j, this.value);
            }
            transaction.commit();
            transaction.closeConnection();
        }
    }

    protected static final class TransSingleOpBench3<T>
    extends BenchRunnable<T> {
        TransactionSingleOp transaction;

        public TransSingleOpBench3(String key, T value, int operations) {
            super(key, value, operations);
        }

        @Override
        protected void init() throws Exception {
            this.transaction = new TransactionSingleOp();
        }

        @Override
        protected void cleanup() throws Exception {
            this.transaction.closeConnection();
        }

        @Override
        protected void operation(int j) throws Exception {
            if (this.value instanceof OtpErlangObject) {
                this.transaction.write(new OtpErlangString(this.key + '_' + j), (OtpErlangObject)this.value);
            } else {
                this.transaction.write(this.key + '_' + j, this.value);
            }
        }
    }

    protected static final class TransSingleOpBench2<T>
    extends BenchRunnable2<T> {
        public TransSingleOpBench2(String key, T value, int operations) {
            super(key, value, operations);
        }

        @Override
        protected void operation(int j) throws Exception {
            TransactionSingleOp transaction = new TransactionSingleOp(this.connection);
            if (this.value instanceof OtpErlangObject) {
                transaction.write(new OtpErlangString(this.key + '_' + j), (OtpErlangObject)this.value);
            } else {
                transaction.write(this.key + '_' + j, this.value);
            }
        }
    }

    protected static final class TransSingleOpBench1<T>
    extends BenchRunnable<T> {
        public TransSingleOpBench1(String key, T value, int operations) {
            super(key, value, operations);
        }

        @Override
        protected void operation(int j) throws Exception {
            TransactionSingleOp transaction = new TransactionSingleOp();
            if (this.value instanceof OtpErlangObject) {
                transaction.write(new OtpErlangString(this.key + '_' + j), (OtpErlangObject)this.value);
            } else {
                transaction.write(this.key + '_' + j, this.value);
            }
            transaction.closeConnection();
        }
    }
}

