/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris.executor;

import com.ericsson.otp.erlang.OtpErlangException;
import de.zib.scalaris.NotFoundException;
import de.zib.scalaris.RequestList;
import de.zib.scalaris.ResultList;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.executor.ScalarisOp;
import de.zib.scalaris.operations.ReadOp;
import de.zib.scalaris.operations.WriteOp;
import java.math.BigInteger;
import java.security.InvalidParameterException;

public class ScalarisIncrementOp1<T extends Number>
implements ScalarisOp {
    protected final String key;
    protected final BigInteger value;

    public ScalarisIncrementOp1(String key, T value) {
        this.key = key;
        if (value instanceof Integer) {
            this.value = BigInteger.valueOf(((Integer)value).intValue());
        } else if (value instanceof Long) {
            this.value = BigInteger.valueOf((Long)value);
        } else if (value instanceof BigInteger) {
            this.value = (BigInteger)value;
        } else {
            throw new InvalidParameterException("Type not supported for increment: " + value.getClass().toString());
        }
    }

    @Override
    public int workPhases() {
        return 2;
    }

    @Override
    public final int doPhase(int phase, int firstOp, ResultList results, RequestList requests) throws OtpErlangException, UnknownException, IllegalArgumentException {
        switch (phase) {
            case 0: {
                return this.prepareRead(requests);
            }
            case 1: {
                return this.prepareWrite(firstOp, results, requests);
            }
            case 2: {
                return this.checkWrite(firstOp, results);
            }
        }
        throw new IllegalArgumentException("No phase " + phase);
    }

    protected int prepareRead(RequestList requests) {
        requests.addOp(new ReadOp(this.key));
        return 0;
    }

    protected int prepareWrite(int firstOp, ResultList results, RequestList requests) throws OtpErlangException, UnknownException {
        BigInteger newValue;
        assert (results != null);
        try {
            newValue = results.processReadAt(firstOp).bigIntValue().add(this.value);
        }
        catch (NotFoundException e) {
            newValue = this.value;
        }
        requests.addOp(new WriteOp(this.key, newValue));
        return 1;
    }

    protected int checkWrite(int firstOp, ResultList results) throws OtpErlangException, UnknownException {
        assert (results != null);
        results.processWriteAt(firstOp);
        return 1;
    }

    @Override
    public String toString() {
        return "Scalaris.increment(" + this.key + ", " + this.value + ")";
    }

    public String getKey() {
        return this.key;
    }

    public BigInteger getIncValue() {
        return this.value;
    }
}

