/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import de.zib.scalaris.AbortException;
import de.zib.scalaris.Benchmark;
import de.zib.scalaris.ConnectionException;
import de.zib.scalaris.ConnectionFactory;
import de.zib.scalaris.DeleteResult;
import de.zib.scalaris.KeyChangedException;
import de.zib.scalaris.Monitor;
import de.zib.scalaris.NotFoundException;
import de.zib.scalaris.ReplicatedDHT;
import de.zib.scalaris.TimeoutException;
import de.zib.scalaris.TransactionSingleOp;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.jmx.MonitorNode;
import de.zib.scalaris.jmx.MonitorService;
import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.HashSet;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    public static void main(String[] args) {
        boolean verbose = false;
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        Options options = Main.getOptions();
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException e) {
            Main.printException("Parsing failed", e, false);
            return;
        }
        if (line.hasOption("verbose")) {
            verbose = true;
            ConnectionFactory.getInstance().printProperties();
        }
        if (line.hasOption("minibench")) {
            int i;
            String[] optionValues = line.getOptionValues("minibench");
            int nrOperations = 500;
            int threadsPerNode = 10;
            HashSet<Integer> benchmarks = new HashSet<Integer>(18);
            boolean all = true;
            if (optionValues != null) {
                Main.checkArguments(optionValues, 0, options, "b");
                if (optionValues.length >= 1) {
                    nrOperations = Integer.parseInt(optionValues[0]);
                }
                if (optionValues.length >= 2) {
                    threadsPerNode = Integer.parseInt(optionValues[1]);
                }
                if (optionValues.length >= 3) {
                    all = false;
                    for (i = 2; i < Math.min(20, optionValues.length); ++i) {
                        String benchmarks_str = optionValues[i];
                        if (benchmarks_str.equals("all")) {
                            all = true;
                            continue;
                        }
                        benchmarks.add(Integer.parseInt(benchmarks_str));
                    }
                }
            }
            if (all) {
                for (i = 1; i <= 18; ++i) {
                    benchmarks.add(i);
                }
            }
            Benchmark.minibench(nrOperations, threadsPerNode, benchmarks);
        } else if (line.hasOption("r")) {
            String key = line.getOptionValue("read");
            Main.checkArguments(key, options, "r");
            try {
                TransactionSingleOp sc = new TransactionSingleOp();
                String value = sc.read(key).value().toString();
                System.out.println("read(" + key + ") == " + value);
            }
            catch (ConnectionException e) {
                Main.printException("read failed with connection error", e, verbose);
            }
            catch (NotFoundException e) {
                Main.printException("read failed with not found", e, verbose);
            }
            catch (UnknownException e) {
                Main.printException("read failed with unknown", e, verbose);
            }
        } else if (line.hasOption("w")) {
            String[] optionValues = line.getOptionValues("write");
            Main.checkArguments(optionValues, 2, options, "w");
            String key = optionValues[0];
            String value = optionValues[1];
            try {
                TransactionSingleOp sc = new TransactionSingleOp();
                sc.write(key, value);
                System.out.println("write(" + key + ", " + value + "): ok");
            }
            catch (ConnectionException e) {
                Main.printException("write failed with connection error", e, verbose);
            }
            catch (AbortException e) {
                Main.printException("write failed with abort", e, verbose);
            }
            catch (UnknownException e) {
                Main.printException("write failed with unknown", e, verbose);
            }
        } else if (line.hasOption("test-and-set")) {
            String[] optionValues = line.getOptionValues("test-and-set");
            Main.checkArguments(optionValues, 3, options, "test-and-set");
            String key = optionValues[0];
            String oldValue = optionValues[1];
            String newValue = optionValues[2];
            try {
                TransactionSingleOp sc = new TransactionSingleOp();
                sc.testAndSet(key, oldValue, newValue);
                System.out.println("testAndSet(" + key + ", " + oldValue + ", " + newValue + "): ok");
            }
            catch (ConnectionException e) {
                Main.printException("testAndSet failed with connection error", e, verbose);
            }
            catch (AbortException e) {
                Main.printException("testAndSet failed with abort", e, verbose);
            }
            catch (UnknownException e) {
                Main.printException("testAndSet failed with unknown", e, verbose);
            }
            catch (NotFoundException e) {
                Main.printException("testAndSet failed with not found", e, verbose);
            }
            catch (KeyChangedException e) {
                Main.printException("testAndSet failed with key changed (current value: " + e.getOldValue().toString() + ")", e, verbose);
            }
        } else if (line.hasOption("d")) {
            String[] optionValues = line.getOptionValues("delete");
            Main.checkArguments(optionValues, 1, options, "d");
            String key = optionValues[0];
            int timeout = 2000;
            if (optionValues.length >= 2) {
                try {
                    timeout = Integer.parseInt(optionValues[1]);
                }
                catch (Exception e) {
                    Main.printException("Parsing failed", new ParseException("wrong type for timeout parameter of option d (parameters: <" + options.getOption("d").getArgName() + ">)"), verbose);
                }
            }
            try {
                ReplicatedDHT sc = new ReplicatedDHT();
                DeleteResult deleteResult = sc.delete(key, timeout);
                System.out.println("delete(" + key + ", " + timeout + "): " + deleteResult.ok + " ok, " + deleteResult.locks_set + " locks_set, " + deleteResult.undef + " undef");
            }
            catch (ConnectionException e) {
                Main.printException("delete failed with connection error", e, verbose);
            }
            catch (TimeoutException e) {
                Main.printException("delete failed with timeout", e, verbose);
            }
            catch (UnknownException e) {
                Main.printException("delete failed with unknown error", e, verbose);
            }
        } else if (line.hasOption("lh")) {
            System.out.println(ConnectionFactory.getLocalhostName());
        } else if (line.hasOption("monitor")) {
            String node = line.getOptionValue("monitor");
            Main.checkArguments(node, options, "monitor");
            try {
                Monitor monitor = new Monitor(node);
                Monitor.GetNodeInfoResult nodeInfo = monitor.getNodeInfo();
                Monitor.GetNodePerformanceResult nodePerf = monitor.getNodePerformance();
                Monitor.GetServiceInfoResult srvInfo = monitor.getServiceInfo();
                Monitor.GetServicePerformanceResult srvPerf = monitor.getServicePerformance();
                Double nodePerfCurLatAvg = Monitor.getCurrentPerfValue(nodePerf.latencyAvg);
                Double nodePerfCurLatStddev = Monitor.getCurrentPerfValue(nodePerf.latencyStddev);
                Double srvPerfCurLatAvg = Monitor.getCurrentPerfValue(srvPerf.latencyAvg);
                Double srcPerfCurLatStddev = Monitor.getCurrentPerfValue(srvPerf.latencyStddev);
                DecimalFormat df = new DecimalFormat("0.##");
                System.out.println("== Node Info ==");
                System.out.println("Scalaris version: " + nodeInfo.scalarisVersion);
                System.out.println("Erlang   version: " + nodeInfo.erlangVersion);
                System.out.println("# of DHT nodes  : " + nodeInfo.dhtNodes);
                System.out.println("== Service Info (from mgmt_server) ==");
                System.out.println("Total # of nodes: " + srvInfo.nodes);
                System.out.println("Total load      : " + srvInfo.totalLoad);
                System.out.println("== Node Performance ==");
                System.out.println("Current latency : " + (nodePerfCurLatAvg == null ? "n/a" : df.format(nodePerfCurLatAvg)));
                System.out.println("Current stddev  : " + (nodePerfCurLatStddev == null ? "n/a" : df.format(nodePerfCurLatStddev)));
                System.out.println("== Service Performance ==");
                System.out.println("Current latency : " + (srvPerfCurLatAvg == null ? "n/a" : df.format(srvPerfCurLatAvg)));
                System.out.println("Current stddev  : " + (srcPerfCurLatStddev == null ? "n/a" : df.format(srcPerfCurLatStddev)));
            }
            catch (ConnectionException e) {
                Main.printException("monitor failed with connection error", e, verbose);
            }
            catch (UnknownException e) {
                Main.printException("monitor failed with unknown error", e, verbose);
            }
        } else if (line.hasOption("jmx")) {
            String node = line.getOptionValue("jmx");
            Main.checkArguments(node, options, "jmx");
            Main.startJmxService(node, verbose);
        } else {
            HelpFormatter formatter = new HelpFormatter();
            formatter.setOptionComparator((Comparator)new Comparator<Option>(){

                private int optionToInt(Option option) {
                    if (option.getLongOpt().equals("help")) {
                        return 1;
                    }
                    if (option.getLongOpt().equals("verbose")) {
                        return 2;
                    }
                    if (option.getLongOpt().equals("localhost")) {
                        return 3;
                    }
                    if (option.getLongOpt().equals("minibench")) {
                        return 4;
                    }
                    if (option.getLongOpt().equals("monitor")) {
                        return 5;
                    }
                    if (option.getLongOpt().equals("read")) {
                        return 6;
                    }
                    if (option.getLongOpt().equals("write")) {
                        return 7;
                    }
                    if (option.getLongOpt().equals("test-and-set")) {
                        return 8;
                    }
                    if (option.getLongOpt().equals("add-del-on-list")) {
                        return 9;
                    }
                    if (option.getLongOpt().equals("add-on-nr")) {
                        return 10;
                    }
                    if (option.getLongOpt().equals("delete")) {
                        return 11;
                    }
                    if (option.getLongOpt().equals("jmxservice")) {
                        return 12;
                    }
                    return 13;
                }

                @Override
                public int compare(Option arg0, Option arg1) {
                    int arg1_i;
                    int arg0_i = this.optionToInt(arg0);
                    if (arg0_i < (arg1_i = this.optionToInt(arg1))) {
                        return -1;
                    }
                    if (arg0_i == arg1_i) {
                        return 0;
                    }
                    return 1;
                }
            });
            formatter.printHelp("scalaris [Options]", Main.getOptions());
            if (!line.hasOption("help")) {
                System.exit(1);
            }
        }
    }

    private static void startJmxService(String node, boolean verbose) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName nodeMonitorName = new ObjectName("de.zib.scalaris:type=MonitorNode");
            MonitorNode nodeMonitorMbean = new MonitorNode(node);
            ObjectName serviceMonitorName = new ObjectName("de.zib.scalaris:type=MonitorService");
            MonitorService serviceMonitorMbean = new MonitorService(node);
            mbs.registerMBean(nodeMonitorMbean, nodeMonitorName);
            mbs.registerMBean(serviceMonitorMbean, serviceMonitorName);
            System.out.println("Waiting forever...");
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException e) {
            System.out.println("stopped service");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        catch (NullPointerException e) {
            throw new RuntimeException(e);
        }
        catch (ConnectionException e) {
            Main.printException("JMX service failed with connection error", e, verbose);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
        catch (MBeanRegistrationException e) {
            throw new RuntimeException(e);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException(e);
        }
    }

    private static Options getOptions() {
        Options options = new Options();
        OptionGroup group = new OptionGroup();
        options.addOption(new Option("h", "help", false, "print this message"));
        options.addOption(new Option("v", "verbose", false, "print verbose information, e.g. the properties read"));
        Option read = new Option("r", "read", true, "read an item");
        read.setArgName("key");
        read.setArgs(1);
        read.setOptionalArg(true);
        group.addOption(read);
        Option write = new Option("w", "write", true, "write an item");
        write.setArgName("key> <value");
        write.setArgs(2);
        write.setOptionalArg(true);
        group.addOption(write);
        Option test_and_set = new Option(null, "test-and-set", true, "atomic test and set, i.e. write <key> to <new> if the current value is <old>");
        test_and_set.setArgName("key> <old> <new");
        test_and_set.setArgs(3);
        test_and_set.setOptionalArg(true);
        group.addOption(test_and_set);
        Option delete = new Option("d", "delete", true, "delete an item (default timeout: 2000ms)\nWARNING: This function can lead to inconsistent data (e.g. deleted items can re-appear). Also when re-creating an item the version before the delete can re-appear.");
        delete.setArgName("key> <[timeout]");
        delete.setArgs(2);
        delete.setOptionalArg(true);
        group.addOption(delete);
        Option bench = new Option("b", "minibench", true, "run selected mini benchmark(s) [1|...|18|all] (default: all benchmarks, 500 operations, 10 threads per Scalaris node)");
        bench.setArgName("[ops]> <[tpn]> <[benchs]");
        bench.setArgs(20);
        bench.setOptionalArg(true);
        group.addOption(bench);
        Option monitor = new Option("m", "monitor", true, "print monitoring information");
        monitor.setArgName("node");
        monitor.setArgs(1);
        monitor.setOptionalArg(true);
        group.addOption(monitor);
        Option jmx = new Option("jmx", "jmxservice", true, "starts a service exposing Scalaris monitoring values via JMX");
        jmx.setArgName("node");
        jmx.setArgs(1);
        jmx.setOptionalArg(true);
        group.addOption(jmx);
        options.addOptionGroup(group);
        options.addOption(new Option("lh", "localhost", false, "gets the local host's name as known to Java (for debugging purposes)"));
        return options;
    }

    static final void printException(String description, ParseException e, boolean verbose) {
        Main.printException(description, (Exception)((Object)e), verbose, 1);
    }

    static final void printException(String description, ConnectionException e, boolean verbose) {
        Main.printException(description, (Exception)((Object)e), verbose, 2);
    }

    static final void printException(String description, TimeoutException e, boolean verbose) {
        Main.printException(description, (Exception)((Object)e), verbose, 3);
    }

    static final void printException(String description, NotFoundException e, boolean verbose) {
        Main.printException(description, (Exception)((Object)e), verbose, 4);
    }

    static final void printException(String description, UnknownException e, boolean verbose) {
        Main.printException(description, e, verbose, 5);
    }

    static final void printException(String description, AbortException e, boolean verbose) {
        Main.printException(description, (Exception)((Object)e), verbose, 7);
    }

    static final void printException(String description, KeyChangedException e, boolean verbose) {
        Main.printException(description, (Exception)((Object)e), verbose, 8);
    }

    static final void printException(String description, Exception e, boolean verbose, int exitStatus) {
        System.err.print(description + ": ");
        if (verbose) {
            System.err.println();
            e.printStackTrace();
        } else {
            System.err.println(e.getMessage());
        }
        System.exit(exitStatus);
    }

    static final void checkArguments(String optionValue, Options options, String currentOption) {
        if (optionValue == null) {
            Main.printException("Parsing failed", new ParseException("missing parameter for option " + currentOption + " (required: <" + options.getOption(currentOption).getArgName() + ">)"), false);
        }
    }

    static final void checkArguments(String[] optionValues, int required, Options options, String currentOption) {
        if (optionValues == null || optionValues.length < required) {
            Main.printException("Parsing failed", new ParseException("missing parameter for option " + currentOption + " (required: <" + options.getOption(currentOption).getArgName() + ">)"), false);
        }
    }
}

