/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris.jmx;

import de.zib.scalaris.ConnectionException;
import de.zib.scalaris.Monitor;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.jmx.MonitorServiceMBean;
import java.util.Map;

public class MonitorService
implements MonitorServiceMBean {
    protected final Monitor monitor;

    public MonitorService(String node) throws ConnectionException {
        this.monitor = new Monitor(node);
    }

    @Override
    public Long getTotalLoad() throws ConnectionException, UnknownException {
        return this.monitor.getServiceInfo().totalLoad;
    }

    @Override
    public Long getNodes() throws ConnectionException, UnknownException {
        return this.monitor.getServiceInfo().nodes;
    }

    @Override
    public Map<Long, Double> getLatencyAvg() throws ConnectionException, UnknownException {
        return this.monitor.getServicePerformance().latencyAvg;
    }

    @Override
    public Map<Long, Double> getLatencyStddev() throws ConnectionException, UnknownException {
        return this.monitor.getServicePerformance().latencyStddev;
    }

    @Override
    public Double getCurLatencyAvg() throws ConnectionException, UnknownException {
        return Monitor.getCurrentPerfValue(this.monitor.getServicePerformance().latencyAvg);
    }

    @Override
    public Double getCurLatencyStddev() throws ConnectionException, UnknownException {
        return Monitor.getCurrentPerfValue(this.monitor.getServicePerformance().latencyStddev);
    }
}

