/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris.executor;

import com.ericsson.otp.erlang.OtpErlangException;
import de.zib.scalaris.RequestList;
import de.zib.scalaris.ResultList;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.executor.ScalarisOp;
import java.util.ArrayList;

public abstract class ScalarisOpExecutor {
    protected final ArrayList<ScalarisOp> ops = new ArrayList();
    protected int workPhases = 0;

    public void addOp(ScalarisOp op) {
        if (op.workPhases() > this.workPhases) {
            this.workPhases = op.workPhases();
        }
        this.ops.add(op);
    }

    public void reset() {
        this.ops.clear();
        this.workPhases = 0;
    }

    public void run() throws OtpErlangException, UnknownException {
        ResultList results = null;
        for (int phase = 0; phase <= this.workPhases; ++phase) {
            RequestList requests = this.newRequestList();
            int curOp = 0;
            for (ScalarisOp op : this.ops) {
                int opPhase = phase - (this.workPhases - op.workPhases());
                if (opPhase < 0 || opPhase > op.workPhases()) continue;
                curOp += op.doPhase(opPhase, curOp, results, requests);
            }
            this.endWorkPhase(phase, requests);
            if (phase == this.workPhases) continue;
            results = this.executeRequests(requests);
        }
    }

    protected void endWorkPhase(int phase, RequestList requests) {
    }

    protected abstract RequestList newRequestList();

    protected abstract ResultList executeRequests(RequestList var1) throws OtpErlangException, UnknownException;

    public int getWorkPhases() {
        return this.workPhases;
    }

    public ArrayList<ScalarisOp> getOps() {
        return this.ops;
    }
}

