/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import de.zib.scalaris.AbortException;
import de.zib.scalaris.ErlangValue;
import de.zib.scalaris.KeyChangedException;
import de.zib.scalaris.NotAListException;
import de.zib.scalaris.NotANumberException;
import de.zib.scalaris.NotFoundException;
import de.zib.scalaris.RequestList;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.operations.Operation;
import de.zib.scalaris.operations.ReadOp;
import java.util.List;

public abstract class ResultList {
    protected final List<Operation> operations;

    protected ResultList(OtpErlangList results, boolean compressed, RequestList requests) throws UnknownException {
        if (results.arity() != requests.size()) {
            throw new UnknownException("Result list size different from request list size!");
        }
        this.operations = requests.getRequests();
        for (int i = 0; i < results.arity(); ++i) {
            OtpErlangObject result = results.elementAt(i);
            this.operations.get(i).setResult(result, compressed);
        }
    }

    public int size() {
        return this.operations.size();
    }

    public Operation get(int index) {
        return this.operations.get(index);
    }

    public ErlangValue processReadAt(int pos) throws NotFoundException, UnknownException {
        return ((ReadOp)this.get(pos)).processResult();
    }

    public abstract void processWriteAt(int var1) throws AbortException, UnknownException;

    public abstract void processAddDelOnListAt(int var1) throws NotAListException, AbortException, UnknownException;

    public abstract void processAddOnNrAt(int var1) throws NotANumberException, AbortException, UnknownException;

    public abstract void processTestAndSetAt(int var1) throws NotFoundException, KeyChangedException, AbortException, UnknownException;

    public String toString() {
        int i = 1;
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Operation op : this.operations) {
            sb.append(op.getResult().toString());
            if (i != this.operations.size()) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }
}

