/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpSelf;
import de.zib.scalaris.Connection;
import de.zib.scalaris.ConnectionException;
import de.zib.scalaris.ConnectionPolicy;
import de.zib.scalaris.DefaultConnectionPolicy;
import de.zib.scalaris.FixedNodeConnectionPolicy;
import de.zib.scalaris.PeerNode;
import de.zib.tools.PropertyLoader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;

public class ConnectionFactory {
    private static final String defaultConfigFile = "scalaris.properties";
    private static final String hostname = ConnectionFactory.findLocalhostName();
    private final List<PeerNode> nodes = Collections.synchronizedList(new ArrayList());
    private String cookie;
    private String clientName;
    private boolean clientNameAppendUUID;
    private final AtomicLong clientNameUUID = new AtomicLong(0L);
    private String configFileUsed;
    private static ConnectionFactory instance = new ConnectionFactory();
    private ConnectionPolicy connectionPolicy = new DefaultConnectionPolicy(this.nodes);

    public static ConnectionFactory getInstance() {
        return instance;
    }

    public ConnectionFactory() {
        Properties properties = new Properties();
        String configFile = System.getProperty("scalaris.java.config");
        if (configFile == null || configFile.length() == 0) {
            configFile = defaultConfigFile;
        }
        PropertyLoader.loadProperties(properties, configFile, true, false, new String[]{"scalaris.node", "scalaris.cookie", "scalaris.client.name", "scalaris.client.appendUUID"});
        this.setProperties(properties);
    }

    public ConnectionFactory(Properties properties) {
        this.setProperties(properties);
    }

    public void setProperties(Properties properties) {
        String[] nodesTemp = properties.getProperty("scalaris.node", "node1@localhost").split("[\\s,;]");
        this.nodes.clear();
        for (String element : nodesTemp) {
            this.addNode(ConnectionFactory.fixLocalhostName(element));
        }
        this.cookie = properties.getProperty("scalaris.cookie", "chocolate chip cookie");
        this.clientName = properties.getProperty("scalaris.client.name", "java_client");
        this.clientNameAppendUUID = properties.getProperty("scalaris.client.appendUUID", "true").equals("true");
        this.configFileUsed = properties.getProperty("PropertyLoader.loadedfile", "");
    }

    public Connection createConnection(String clientName, boolean clientNameAppendUUID, ConnectionPolicy connectionPolicy) throws ConnectionException {
        if (clientNameAppendUUID) {
            clientName = clientName + "_" + this.clientNameUUID.getAndIncrement();
        }
        try {
            OtpSelf self = new OtpSelf(clientName + "@" + ConnectionFactory.getLocalhostName(), this.cookie);
            return new Connection(self, connectionPolicy);
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    public Connection createConnection(String clientName, boolean clientNameAppendUUID) throws ConnectionException {
        return this.createConnection(clientName, clientNameAppendUUID, this.connectionPolicy);
    }

    public Connection createConnection(String clientName) throws ConnectionException {
        return this.createConnection(clientName, this.clientNameAppendUUID);
    }

    public Connection createConnection(ConnectionPolicy connectionPolicy) throws ConnectionException {
        return this.createConnection(this.clientName, this.clientNameAppendUUID, connectionPolicy);
    }

    public Connection createConnection() throws ConnectionException {
        return this.createConnection(this.clientName);
    }

    public static String fixLocalhostName(String node) {
        if (node.endsWith("@localhost")) {
            return node.replaceAll("@localhost$", "@" + ConnectionFactory.getLocalhostName());
        }
        if (node.indexOf(64) == -1) {
            return node + "@" + ConnectionFactory.getLocalhostName();
        }
        return node;
    }

    public static final String getLocalhostName() {
        return hostname;
    }

    private static final String findLocalhostName() {
        String hostname = "localhost";
        String erlangNodeName = System.getProperty("scalaris.erlang.nodename");
        if (erlangNodeName == null || erlangNodeName.length() == 0) {
            try {
                hostname = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {}
        } else {
            hostname = erlangNodeName;
        }
        return hostname;
    }

    public void printProperties() {
        this.printProperties(System.out);
    }

    public void printProperties(PrintStream out) {
        out.println("ConnectionFactory properties:");
        out.println("  config file                = " + this.configFileUsed);
        out.println("  scalaris.node              = " + this.nodes.toString());
        out.println("  scalaris.cookie            = " + this.cookie);
        out.println("  scalaris.client.name       = " + this.clientName);
        out.println("  scalaris.client.appendUUID = " + this.clientNameAppendUUID);
    }

    public List<PeerNode> getNodes() {
        return new ArrayList<PeerNode>(this.nodes);
    }

    @Deprecated
    public String getNode() {
        if (this.nodes.size() > 0) {
            return this.nodes.get(0).getNode().node();
        }
        return "";
    }

    public void setNode(String node) {
        this.nodes.clear();
        this.connectionPolicy.availableNodesReset();
        this.addNode(node);
    }

    public void setNode(PeerNode node) {
        this.nodes.clear();
        this.connectionPolicy.availableNodesReset();
        this.addNode(node);
    }

    public void addNode(String node) {
        PeerNode p = new PeerNode(node);
        this.addNode(p);
    }

    public void addNode(PeerNode node) {
        this.nodes.add(node);
        this.connectionPolicy.availableNodeAdded(node);
    }

    public void removeNode(PeerNode node) {
        this.nodes.remove(node);
        this.connectionPolicy.availableNodeRemoved(node);
    }

    public void testAllNodes() {
        this.connectionPolicy.availableNodesReset();
        for (PeerNode node : this.nodes) {
            node.resetFailureCount();
            try {
                this.createConnection(new FixedNodeConnectionPolicy(node)).close();
            }
            catch (ConnectionException connectionException) {
                // empty catch block
            }
            this.connectionPolicy.availableNodeAdded(node);
        }
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public boolean isClientNameAppendUUID() {
        return this.clientNameAppendUUID;
    }

    public void setClientNameAppendUUID(boolean clientNameAppendUUID) {
        this.clientNameAppendUUID = clientNameAppendUUID;
    }

    public void setConnectionPolicy(ConnectionPolicy connectionPolicy) {
        this.connectionPolicy = connectionPolicy;
    }

    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }
}

