/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpConnection;
import com.ericsson.otp.erlang.OtpErlangExit;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpSelf;
import de.zib.scalaris.ConnectionException;
import de.zib.scalaris.ConnectionPolicy;
import de.zib.scalaris.DefaultConnectionPolicy;
import de.zib.scalaris.PeerNode;
import java.io.IOException;
import java.net.UnknownHostException;

public class Connection {
    OtpConnection connection;
    OtpSelf self;
    PeerNode remote;
    ConnectionPolicy connectionPolicy;

    public Connection(OtpSelf self, PeerNode remote) throws UnknownHostException, IOException, OtpAuthException {
        this.self = self;
        this.connectionPolicy = new DefaultConnectionPolicy(remote);
        this.remote = this.connectionPolicy.selectNode();
        this.connect();
    }

    public Connection(OtpSelf self, ConnectionPolicy connectionPolicy) throws UnknownHostException, IOException, OtpAuthException {
        this.self = self;
        this.remote = connectionPolicy.selectNode();
        this.connectionPolicy = connectionPolicy;
        this.connect();
    }

    private void connect() throws UnknownHostException, IOException, OtpAuthException {
        boolean success = false;
        int retry = 0;
        while (!success) {
            try {
                this.connection = this.self.connect(this.remote.getNode());
                this.connectionPolicy.nodeConnectSuccess(this.remote);
                success = true;
            }
            catch (UnknownHostException e) {
                this.connectionPolicy.nodeFailed(this.remote);
                this.remote = this.connectionPolicy.selectNode(++retry, this.remote, e);
            }
            catch (OtpAuthException e) {
                this.connectionPolicy.nodeFailed(this.remote);
                this.remote = this.connectionPolicy.selectNode(++retry, this.remote, e);
            }
            catch (IOException e) {
                this.connectionPolicy.nodeFailed(this.remote);
                this.remote = this.connectionPolicy.selectNode(++retry, this.remote, e);
            }
        }
    }

    private void reconnect() throws UnknownHostException, IOException, OtpAuthException {
        this.close();
        this.connect();
    }

    public OtpErlangObject doRPC(String mod, String fun, OtpErlangList args) throws ConnectionException {
        try {
            boolean success = false;
            boolean isConnected = this.connection.isConnected();
            while (!success) {
                try {
                    this.connection.sendRPC(mod, fun, args);
                    OtpErlangObject result = this.connection.receiveRPC();
                    if (result == null) continue;
                    success = true;
                    return result;
                }
                catch (OtpErlangExit e) {
                    this.connectionPolicy.nodeFailed(this.remote);
                    this.remote = this.connectionPolicy.selectNode(1, this.remote, e);
                    this.reconnect();
                }
                catch (OtpAuthException e) {
                    this.connectionPolicy.nodeFailed(this.remote);
                    this.remote = this.connectionPolicy.selectNode(1, this.remote, e);
                    this.reconnect();
                }
                catch (IOException e) {
                    if (isConnected) {
                        this.connectionPolicy.nodeFailed(this.remote);
                    }
                    this.remote = this.connectionPolicy.selectNode(1, this.remote, e);
                    this.reconnect();
                }
            }
            throw new InternalError();
        }
        catch (OtpErlangExit e) {
            throw new ConnectionException(e);
        }
        catch (OtpAuthException e) {
            throw new ConnectionException(e);
        }
        catch (IOException e) {
            throw new ConnectionException(e);
        }
    }

    public OtpErlangObject doRPC(String mod, String fun, OtpErlangObject[] args) throws ConnectionException {
        return this.doRPC(mod, fun, new OtpErlangList(args));
    }

    public void sendRPC(String mod, String fun, OtpErlangList args) throws ConnectionException {
        try {
            boolean success = false;
            while (!success) {
                try {
                    this.connection.sendRPC(mod, fun, args);
                    success = true;
                    return;
                }
                catch (IOException e) {
                    this.connectionPolicy.nodeFailed(this.remote);
                    this.remote = this.connectionPolicy.selectNode(1, this.remote, e);
                    this.reconnect();
                }
            }
            throw new InternalError();
        }
        catch (OtpAuthException e) {
            throw new ConnectionException(e);
        }
        catch (IOException e) {
            throw new ConnectionException(e);
        }
    }

    public void sendRPC(String mod, String fun, OtpErlangObject[] args) throws ConnectionException {
        this.sendRPC(mod, fun, new OtpErlangList(args));
    }

    public void close() {
        this.connection.close();
    }

    public OtpSelf getSelf() {
        return this.self;
    }

    public PeerNode getRemote() {
        return this.remote;
    }

    public OtpConnection getConnection() {
        return this.connection;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

