/*
 * Decompiled with CFR 0.152.
 */
package de.zib.scalaris;

import com.ericsson.otp.erlang.OtpErlangDouble;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import de.zib.scalaris.AbortException;
import de.zib.scalaris.Connection;
import de.zib.scalaris.ConnectionException;
import de.zib.scalaris.ConnectionFactory;
import de.zib.scalaris.ErlangValue;
import de.zib.scalaris.KeyChangedException;
import de.zib.scalaris.NotAListException;
import de.zib.scalaris.NotANumberException;
import de.zib.scalaris.NotFoundException;
import de.zib.scalaris.RequestList;
import de.zib.scalaris.ResultList;
import de.zib.scalaris.UnknownException;
import de.zib.scalaris.operations.AddDelOnListOp;
import de.zib.scalaris.operations.AddOnNrOp;
import de.zib.scalaris.operations.Operation;
import de.zib.scalaris.operations.ReadOp;
import de.zib.scalaris.operations.TestAndSetOp;
import de.zib.scalaris.operations.WriteOp;
import java.util.List;

public abstract class AbstractTransaction<ReqL extends RequestList, ResL extends ResultList> {
    protected final Connection connection;
    protected boolean compressed = true;

    public AbstractTransaction() throws ConnectionException {
        this.connection = ConnectionFactory.getInstance().createConnection();
    }

    public AbstractTransaction(Connection conn) {
        this.connection = conn;
    }

    protected abstract ReqL newReqList();

    protected ResL req_list(Operation op) throws ConnectionException, AbortException, UnknownException {
        ReqL reqList = this.newReqList();
        ((RequestList)reqList).addOp(op);
        return this.req_list(reqList);
    }

    public abstract ResL req_list(ReqL var1) throws ConnectionException, AbortException, UnknownException;

    protected String module() {
        return this.compressed ? "api_txc" : "api_tx";
    }

    public ErlangValue read(OtpErlangString key) throws ConnectionException, NotFoundException, UnknownException {
        try {
            ResL result = this.req_list((ReqL)new ReadOp(key));
            return ((ResultList)result).processReadAt(0);
        }
        catch (AbortException e) {
            throw new UnknownException((Throwable)((Object)e));
        }
    }

    public ErlangValue read(String key) throws ConnectionException, NotFoundException, UnknownException {
        return this.read(new OtpErlangString(key));
    }

    public void write(OtpErlangString key, OtpErlangObject value) throws ConnectionException, AbortException, UnknownException {
        ResL result = this.req_list((ReqL)new WriteOp(key, value));
        ((ResultList)result).processWriteAt(0);
    }

    public <T> void write(String key, T value) throws ConnectionException, AbortException, UnknownException {
        this.write(new OtpErlangString(key), ErlangValue.convertToErlang(value));
    }

    public void addDelOnList(OtpErlangString key, OtpErlangList toAdd, OtpErlangList toRemove) throws ConnectionException, NotAListException, AbortException, UnknownException {
        ResL result = this.req_list((ReqL)new AddDelOnListOp(key, toAdd, toRemove));
        ((ResultList)result).processAddDelOnListAt(0);
    }

    public <T> void addDelOnList(String key, List<T> toAdd, List<T> toRemove) throws ConnectionException, NotAListException, AbortException, UnknownException {
        OtpErlangList toRemoveErl;
        OtpErlangList toAddErl;
        try {
            toAddErl = (OtpErlangList)ErlangValue.convertToErlang(toAdd);
            toRemoveErl = (OtpErlangList)ErlangValue.convertToErlang(toRemove);
        }
        catch (ClassCastException e) {
            throw new NotAListException(e);
        }
        this.addDelOnList(new OtpErlangString(key), toAddErl, toRemoveErl);
    }

    public void addOnNr(OtpErlangString key, OtpErlangLong toAdd) throws ConnectionException, NotANumberException, AbortException, UnknownException {
        this.addOnNr_(new AddOnNrOp(key, toAdd));
    }

    public void addOnNr(OtpErlangString key, OtpErlangDouble toAdd) throws ConnectionException, NotANumberException, AbortException, UnknownException {
        this.addOnNr_(new AddOnNrOp(key, toAdd));
    }

    protected void addOnNr_(AddOnNrOp op) throws ConnectionException, NotANumberException, AbortException, UnknownException {
        ResL result = this.req_list((ReqL)op);
        ((ResultList)result).processAddOnNrAt(0);
    }

    public <T> void addOnNr(String key, T toAdd) throws ConnectionException, NotANumberException, AbortException, UnknownException {
        OtpErlangObject toAddErl = ErlangValue.convertToErlang(toAdd);
        if (toAddErl instanceof OtpErlangLong) {
            this.addOnNr(new OtpErlangString(key), (OtpErlangLong)toAddErl);
        } else if (toAddErl instanceof OtpErlangDouble) {
            this.addOnNr(new OtpErlangString(key), (OtpErlangDouble)toAddErl);
        } else {
            throw new NotANumberException(toAddErl);
        }
    }

    public void testAndSet(OtpErlangString key, OtpErlangObject oldValue, OtpErlangObject newValue) throws ConnectionException, NotFoundException, KeyChangedException, AbortException, UnknownException {
        ResL result = this.req_list((ReqL)new TestAndSetOp(key, oldValue, newValue));
        ((ResultList)result).processTestAndSetAt(0);
    }

    public <OldT, NewT> void testAndSet(String key, OldT oldValue, NewT newValue) throws ConnectionException, NotFoundException, KeyChangedException, AbortException, UnknownException {
        this.testAndSet(new OtpErlangString(key), ErlangValue.convertToErlang(oldValue), ErlangValue.convertToErlang(newValue));
    }

    public void closeConnection() {
        this.connection.close();
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }
}

