
if (CMAKE_VERSION VERSION_LESS 2.8.3)
    message(FATAL_ERROR "Qt 5 requires at least CMake version 2.8.3")
endif()

get_filename_component(_qt5Uml_install_prefix "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

set(Qt5Uml_VERSION_MAJOR 5)
set(Qt5Uml_VERSION_MINOR 0)
set(Qt5Uml_VERSION_PATCH 0)
set(Qt5Uml_VERSION_STRING 5.0.0)

set(Qt5Uml_LIBRARIES Qt5::Uml)

set(Qt5Uml_INCLUDE_DIRS "${_qt5Uml_install_prefix}/include/qt5/" "${_qt5Uml_install_prefix}/include/qt5/QtUml")
set(Qt5Uml_PRIVATE_INCLUDE_DIRS
    "${_qt5Uml_install_prefix}/include/qt5/QtUml/${Qt5Uml_VERSION_STRING}"
    "${_qt5Uml_install_prefix}/include/qt5/QtUml/${Qt5Uml_VERSION_STRING}/QtUml"
)

set(Qt5Uml_DEFINITIONS -DQT_UML_LIB)
set(Qt5Uml_COMPILE_DEFINITIONS QT_UML_LIB)

set(_Qt5Uml_MODULE_DEPENDENCIES "WrappedObjects;Core")

set(_Qt5Uml_FIND_DEPENDENCIES_REQUIRED)
if (Qt5Uml_FIND_REQUIRED)
    set(_Qt5Uml_FIND_DEPENDENCIES_REQUIRED REQUIRED)
endif()
set(_Qt5Uml_FIND_DEPENDENCIES_QUIET)
if (Qt5Uml_FIND_QUIETLY)
    set(_Qt5Uml_DEPENDENCIES_FIND_QUIET QUIET)
endif()

foreach(_module_dep ${_Qt5Uml_MODULE_DEPENDENCIES})
    if (NOT Qt5${_module_dep}_FOUND)
        find_package(Qt5${_module_dep}
            ${_Qt5Uml_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Uml_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${_qt5Uml_install_prefix}" NO_DEFAULT_PATH
        )
    endif()

    if (NOT Qt5${_module_dep}_FOUND)
        set(Qt5Uml_FOUND False)
        return()
    endif()

    list(APPEND Qt5Uml_INCLUDE_DIRS "${Qt5${_module_dep}_INCLUDE_DIRS}")
    list(APPEND Qt5Uml_PRIVATE_INCLUDE_DIRS "${Qt5${_module_dep}_PRIVATE_INCLUDE_DIRS}")
    list(APPEND Qt5Uml_DEFINITIONS ${Qt5${_module_dep}_DEFINITIONS})
    list(APPEND Qt5Uml_COMPILE_DEFINITIONS ${Qt5${_module_dep}_COMPILE_DEFINITIONS})
    list(APPEND Qt5Uml_EXECUTABLE_COMPILE_FLAGS ${Qt5${_module_dep}_EXECUTABLE_COMPILE_FLAGS})
endforeach()
list(REMOVE_DUPLICATES Qt5Uml_INCLUDE_DIRS)
list(REMOVE_DUPLICATES Qt5Uml_PRIVATE_INCLUDE_DIRS)
list(REMOVE_DUPLICATES Qt5Uml_DEFINITIONS)
list(REMOVE_DUPLICATES Qt5Uml_COMPILE_DEFINITIONS)
if (Qt5Uml_EXECUTABLE_COMPILE_FLAGS)
  list(REMOVE_DUPLICATES Qt5Uml_EXECUTABLE_COMPILE_FLAGS)
endif()

set(_Qt5Uml_LIB_DEPENDENCIES "Qt5::WrappedObjects;Qt5::Core")

macro(_populate_imported_target_properties Configuration LIB_LOCATION IMPLIB_LOCATION)
    set_property(TARGET Qt5::Uml APPEND PROPERTY IMPORTED_CONFIGURATIONS ${Configuration})

    set_target_properties(Qt5::Uml PROPERTIES
        "IMPORTED_LINK_INTERFACE_LIBRARIES_${Configuration}" "${_Qt5Uml_LIB_DEPENDENCIES}"
        "IMPORTED_LOCATION_${Configuration}" "${_qt5Uml_install_prefix}/lib/${LIB_LOCATION}"
        "IMPORTED_SONAME_${Configuration}" "libQt5Uml.so.5"
    )
endmacro()

if (NOT TARGET Qt5::Uml)
    add_library(Qt5::Uml SHARED IMPORTED)


    _populate_imported_target_properties(RELEASE "libQt5Uml.so.5.0.0" "" )



endif()


