#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: QuickCheck
version: 2.7.6
id: QuickCheck-2.7.6-855bffeb5f977a12fd622f156ee8db01

license: BSD3
copyright: 2000-2014 Koen Claessen, 2006-2008 Björn Bringert, 2009-2014 Nick Smallbone
maintainer: QuickCheck developers <quickcheck@projects.haskell.org>
stability:
homepage: https://github.com/nick8325/quickcheck
package-url:
synopsis: Automatic testing of Haskell programs
description: QuickCheck is a library for random testing of program properties.
             .
             The programmer provides a specification of the program, in
             the form of properties which functions should satisfy, and
             QuickCheck then tests that the properties hold in a large number
             of randomly generated cases.
             .
             Specifications are expressed in
             Haskell, using combinators defined in the QuickCheck library.
             QuickCheck provides combinators to define properties, observe
             the distribution of test data, and define test
             data generators.
category: Testing
author: Koen Claessen <koen@chalmers.se>
exposed: True
exposed-modules: Test.QuickCheck Test.QuickCheck.Arbitrary
                 Test.QuickCheck.Gen Test.QuickCheck.Gen.Unsafe
                 Test.QuickCheck.Monadic Test.QuickCheck.Modifiers
                 Test.QuickCheck.Property Test.QuickCheck.Test Test.QuickCheck.Text
                 Test.QuickCheck.Poly Test.QuickCheck.State Test.QuickCheck.Random
                 Test.QuickCheck.Exception Test.QuickCheck.Function
                 Test.QuickCheck.All
hidden-modules:
trusted: False
import-dirs: /usr/lib/ghc-7.8.4/site-local/QuickCheck-2.7.6
library-dirs: /usr/lib/ghc-7.8.4/site-local/QuickCheck-2.7.6
hs-libraries: HSQuickCheck-2.7.6
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.7.0.2-92d91acd5693cbee0bcb50929127adb1
         random-1.0.1.1-b6a433cfd620e4a9f90f1e9861e1ca53
         template-haskell-2.9.0.0-0434aed654f4aa41edcedb7be279f882
         tf-random-0.4-08ecc14d30d2f05d94182ed3b84c18e2
         transformers-0.3.0.0-164cdf31d42d2d5e3c85dc713dbb8551
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/share/doc/haskell-quickcheck/html/QuickCheck.haddock
haddock-html: /usr/share/doc/haskell-quickcheck/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
