#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tf-random
version: 0.4
id: tf-random-0.4-08ecc14d30d2f05d94182ed3b84c18e2

license: BSD3
copyright:
maintainer: Michał Pałka <michal.palka@chalmers.se>
stability:
homepage:
package-url:
synopsis: High-quality splittable pseudorandom number generator
description: This package contains an implementation of a high-quality splittable pseudorandom number generator. The generator is based on a cryptographic hash function built on top of the ThreeFish block cipher. See the paper /Splittable Pseudorandom Number Generators Using Cryptographic Hashing/ by Claessen, Pałka for details and the rationale of the design.
             .
             The package provides the following:
             .
             * A splittable PRNG that implements the standard '\''System.Random.RandomGen'\'' class.
             .
             * The generator also implements an alternative version of the '\''System.Random.TF.Gen.RandomGen'\'' class (exported from "System.Random.TF.Gen"), which requires the generator to return pseudorandom integers from the full 32-bit range, and contains an n-way split function.
             .
             * An alternative version of the @Random@ class is provided, which is linked to the new @RandomGen@ class, together with @Random@ instances for some integral types.
             .
             * Two functions for initialising the generator with a non-deterministic seed: one using the system time, and one using the @\/dev\/urandom@ UNIX special file.
             .
             The package uses an adapted version of the reference C implementation of ThreeFish from the reference package of the Skein hash function (<https://www.schneier.com/skein.html>), originally written by Doug Whiting.
             .
             Please note that even though the generator provides very high-quality pseudorandom numbers, it has not been designed with cryptographic applications in mind.
category: Random
author: Michał Pałka <michal.palka@chalmers.se>
exposed: True
exposed-modules: System.Random.TF System.Random.TF.Gen
                 System.Random.TF.Init System.Random.TF.Instances
hidden-modules:
trusted: False
import-dirs: /usr/lib/ghc-7.8.4/site-local/tf-random-0.4
library-dirs: /usr/lib/ghc-7.8.4/site-local/tf-random-0.4
hs-libraries: HStf-random-0.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.7.0.2-92d91acd5693cbee0bcb50929127adb1
         primitive-0.5.2.1-a4f5914768bd6bb150b0e316bd37b85c
         random-1.0.1.1-b6a433cfd620e4a9f90f1e9861e1ca53
         time-1.4.2-c87eebe9a489baceb5bce3a223b18344
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/share/doc/haskell-tf-random/html/tf-random.haddock
haddock-html: /usr/share/doc/haskell-tf-random/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
