/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.fluidsynth;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.player.base.MidiOutputPortProvider;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiOutputPortImpl;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiOutputPortSettings;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiSynth;

public class MidiOutputPortProviderImpl
implements MidiOutputPortProvider {
    private MidiSynth synth;
    private MidiOutputPortSettings settings;

    public List listPorts() throws MidiPlayerException {
        try {
            ArrayList<MidiOutputPortImpl> arrayList = new ArrayList<MidiOutputPortImpl>();
            Iterator iterator = this.getSettings().getSoundfonts().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                File file = new File(string);
                if (!file.exists() || file.isDirectory()) continue;
                arrayList.add(new MidiOutputPortImpl(this.getSynth(), file));
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            throw new MidiPlayerException(throwable.getMessage(), throwable);
        }
    }

    public void closeAll() throws MidiPlayerException {
        try {
            if (this.synth != null && this.synth.isInitialized()) {
                this.synth.finalize();
                this.synth = null;
            }
        }
        catch (Throwable throwable) {
            throw new MidiPlayerException(throwable.getMessage(), throwable);
        }
    }

    public MidiSynth getSynth() {
        if (this.synth == null || !this.synth.isInitialized()) {
            this.synth = new MidiSynth();
            this.getSettings().apply();
        }
        return this.synth;
    }

    public MidiOutputPortSettings getSettings() {
        if (this.settings == null) {
            this.settings = new MidiOutputPortSettings(this);
        }
        return this.settings;
    }
}

