/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.assistant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.impl.jsa.assistant.SBInstallerlistener;
import org.herac.tuxguitar.player.impl.jsa.midiport.MidiPortSynthesizer;
import org.herac.tuxguitar.player.impl.jsa.utils.MidiConfigUtils;

public class SBInstaller {
    private static final String SB_PREFIX = "soundbank";
    private static final String SB_EXTENSION = ".gm";
    private boolean cancelled;
    private URL url;
    private File tmpPath;
    private File dstPath;
    private MidiPortSynthesizer synthesizer;
    private SBInstallerlistener listener;

    public SBInstaller(URL uRL, File file, File file2, MidiPortSynthesizer midiPortSynthesizer, SBInstallerlistener sBInstallerlistener) {
        this.url = uRL;
        this.tmpPath = file;
        this.dstPath = file2;
        this.synthesizer = midiPortSynthesizer;
        this.listener = sBInstallerlistener;
        this.cancelled = false;
    }

    public void process() {
        File file = new File(this.tmpPath.getAbsolutePath() + File.separator + "soundbank.zip");
        boolean bl = this.download(this.url, file);
        if (bl && !this.isCancelled()) {
            File file2 = this.uncompress(file);
            if (!this.isCancelled() && file2 != null) {
                this.install(file2);
            }
        }
        if (file.exists()) {
            file.delete();
        }
        this.listener.notifyFinish();
    }

    private boolean download(URL uRL, File file) {
        try {
            this.listener.notifyProcess(TuxGuitar.getProperty((String)"jsa.soundbank-assistant.process.downloading"));
            InputStream inputStream = uRL.openStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            int n = 0;
            while (!this.isCancelled() && (n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            inputStream.close();
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    private File uncompress(File file) {
        try {
            this.listener.notifyProcess(TuxGuitar.getProperty((String)"jsa.soundbank-assistant.process.uncompressing", (String[])new String[]{file.getAbsolutePath()}));
            if (file.exists()) {
                File file2 = null;
                ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
                ZipEntry zipEntry = null;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    String string = zipEntry.getName();
                    if (string.indexOf(SB_PREFIX) != 0 || string.indexOf(SB_EXTENSION) != string.length() - SB_EXTENSION.length()) continue;
                    file2 = new File(this.dstPath.getAbsolutePath() + File.separator + string);
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    while ((n = zipInputStream.read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    }
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                }
                zipInputStream.close();
                return file2;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    private void install(File file) {
        try {
            this.listener.notifyProcess(TuxGuitar.getProperty((String)"jsa.soundbank-assistant.process.installing", (String[])new String[]{file.getAbsolutePath()}));
            if (!this.synthesizer.loadSoundbank(file)) {
                this.listener.notifyFailed((Throwable)new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.soundbank.custom")));
                return;
            }
            TGConfigManager tGConfigManager = MidiConfigUtils.getConfig();
            tGConfigManager.setProperty("soundbank.custom.path", file.getAbsolutePath());
            tGConfigManager.save();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }
}

