/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.lilypond;

import java.io.OutputStream;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGLocalFileExporter;
import org.herac.tuxguitar.io.lilypond.LilypondOutputStream;
import org.herac.tuxguitar.io.lilypond.LilypondSettings;
import org.herac.tuxguitar.io.lilypond.LilypondSettingsDialog;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGSong;

public class LilypondSongExporter
implements TGLocalFileExporter {
    private OutputStream stream;
    private LilypondSettings settings;

    public String getExportName() {
        return "Lilypond";
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("Lilypond", "*.ly");
    }

    public boolean configure(boolean bl) {
        this.settings = bl ? LilypondSettings.getDefaults() : new LilypondSettingsDialog().open();
        return this.settings != null;
    }

    public void init(TGFactory tGFactory, OutputStream outputStream) {
        this.stream = outputStream;
    }

    public void exportSong(TGSong tGSong) {
        if (this.stream != null && this.settings != null) {
            new LilypondOutputStream(this.stream, this.settings).writeSong(tGSong);
        }
    }
}

