/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.gui.system.plugins.TGPluginConfigManager;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.io.gtp.GTPSettings;

public class GTPSettingsUtil {
    private static final String KEY_CHARSET = "charset";
    private static GTPSettingsUtil instance;
    private TGConfigManager config;
    private GTPSettings settings = new GTPSettings();

    private GTPSettingsUtil() {
    }

    public static GTPSettingsUtil instance() {
        if (instance == null) {
            instance = new GTPSettingsUtil();
        }
        return instance;
    }

    public GTPSettings getSettings() {
        return this.settings;
    }

    public TGConfigManager getConfig() {
        if (this.config == null) {
            this.config = new TGPluginConfigManager("tuxguitar-gtp");
            this.config.init();
        }
        return this.config;
    }

    public void load() {
        String string = System.getProperty("file.encoding");
        if (string == null) {
            string = "UTF-8";
        }
        this.settings.setCharset(this.getConfig().getStringConfigValue(KEY_CHARSET, string));
    }

    public void configure(Shell shell) {
        String string;
        final List list = this.getAvailableCharsets();
        final Shell shell2 = DialogUtils.newDialog((Shell)shell, (int)67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setText(TuxGuitar.getProperty((String)"gtp.settings.title"));
        Group group = new Group((Composite)shell2, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"gtp.settings.charset.tip"));
        Label label = new Label((Composite)group, 16384);
        label.setText(TuxGuitar.getProperty((String)"gtp.settings.charset.select") + ":");
        final Combo combo = new Combo((Composite)group, 12);
        combo.setLayoutData((Object)new GridData(250, -1));
        for (int i = 0; i < list.size(); ++i) {
            string = (String)list.get(i);
            combo.add(string);
            if (!string.equals(this.settings.getCharset())) continue;
            combo.select(i);
        }
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        string = new GridData(4, 4, true, true);
        ((GridData)string).minimumWidth = 80;
        ((GridData)string).minimumHeight = 25;
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty((String)"ok"));
        button.setLayoutData((Object)string);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = combo.getSelectionIndex();
                if (n >= 0 && n < list.size()) {
                    TGConfigManager tGConfigManager = GTPSettingsUtil.this.getConfig();
                    tGConfigManager.setProperty(GTPSettingsUtil.KEY_CHARSET, (String)list.get(n));
                    tGConfigManager.save();
                    GTPSettingsUtil.this.load();
                }
                shell2.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty((String)"cancel"));
        button2.setLayoutData((Object)string);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button);
        DialogUtils.openDialog((Shell)shell2, (int)11);
    }

    private List getAvailableCharsets() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Map.Entry<String, Charset>> iterator = Charset.availableCharsets().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Charset> entry = iterator.next();
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }
}

