/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.tray;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.herac.tuxguitar.gui.TuxGuitar;

public class TGTrayMenu {
    private Menu menu;
    private MenuItem play;
    private MenuItem stop;
    private MenuItem exit;

    public void make() {
        this.menu = new Menu((Decorations)TuxGuitar.instance().getShell(), 8);
        this.play = new MenuItem(this.menu, 8);
        this.play.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.transport.play"));
        this.stop = new MenuItem(this.menu, 8);
        this.stop.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.transport.stop"));
        new MenuItem(this.menu, 2);
        this.exit = new MenuItem(this.menu, 8);
        this.exit.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.exit"));
        this.loadProperties();
        this.loadIcons();
    }

    public void loadProperties() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.play.setText(TuxGuitar.getProperty((String)"transport.start"));
            this.stop.setText(TuxGuitar.getProperty((String)"transport.stop"));
            this.exit.setText(TuxGuitar.getProperty((String)"file.exit"));
        }
    }

    public void loadIcons() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.stop.setImage(TuxGuitar.instance().getIconManager().getTransportIconStop1());
            this.play.setImage(TuxGuitar.instance().getIconManager().getTransportIconPlay1());
        }
    }

    public void show() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.setVisible(true);
        }
    }

    public void dispose() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
    }
}

