/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.tray;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.icons.IconLoader;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;
import org.herac.tuxguitar.tray.TGTrayIcon;
import org.herac.tuxguitar.tray.TGTrayMenu;

public class TGTray
implements IconLoader,
LanguageLoader {
    private boolean visible;
    private Display display = TuxGuitar.instance().getDisplay();
    private Tray tray = this.display.getSystemTray();
    private TGTrayIcon icon = new TGTrayIcon();
    private TGTrayMenu menu = new TGTrayMenu();

    public TGTray() {
        TuxGuitar.instance().getIconManager().addLoader((IconLoader)this);
        TuxGuitar.instance().getLanguageManager().addLoader((LanguageLoader)this);
    }

    public void removeTray() {
        if (this.tray != null) {
            this.setVisible(true);
            TrayItem[] trayItemArray = this.tray.getItems();
            for (int i = 0; i < trayItemArray.length; ++i) {
                trayItemArray[i].dispose();
            }
            this.icon.dispose();
            this.menu.dispose();
        }
    }

    public void addTray() {
        if (this.tray != null) {
            this.menu.make();
            this.visible = true;
            TrayItem trayItem = new TrayItem(this.tray, 0);
            trayItem.setToolTipText("TuxGuitar");
            trayItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TGTray.this.setVisible();
                }
            });
            trayItem.addListener(35, new Listener(){

                public void handleEvent(Event event) {
                    TGTray.this.showMenu();
                }
            });
            this.icon.setItem(trayItem);
            this.loadIcons();
        }
    }

    public void loadIcons() {
        this.icon.loadImage();
        this.menu.loadIcons();
    }

    public void loadProperties() {
        this.menu.loadProperties();
    }

    protected void setVisible() {
        this.setVisible(!this.visible);
    }

    protected void setVisible(boolean bl) {
        if (this.tray != null) {
            Shell[] shellArray = this.display.getShells();
            for (int i = 0; i < shellArray.length; ++i) {
                shellArray[i].setVisible(bl);
            }
            this.visible = bl;
        }
    }

    protected void showMenu() {
        this.menu.show();
    }
}

