/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.ascii;

import java.io.PrintStream;
import java.io.PrintWriter;

public class ASCIIOutputStream {
    private PrintWriter writer;
    private int x;
    private int y;

    public ASCIIOutputStream(PrintStream printStream) {
        this.writer = new PrintWriter(printStream);
    }

    public void drawNote(int n) {
        this.movePoint(this.getPosX() + (n >= 10 ? 2 : 1), this.getPosY());
        this.writer.print(n);
    }

    public void drawStringSegments(int n) {
        this.movePoint(this.getPosX() + n, this.getPosY());
        for (int i = 0; i < n; ++i) {
            this.writer.print("-");
        }
    }

    public void drawTuneSegment(String string, int n) {
        for (int i = string.length(); i < n; ++i) {
            this.drawSpace();
        }
        this.movePoint(this.getPosX() + string.length(), this.getPosY());
        this.writer.print(string);
    }

    public void drawBarSegment() {
        this.movePoint(this.getPosX() + 1, this.getPosY());
        this.writer.print("|");
    }

    public void nextLine() {
        this.movePoint(0, this.getPosY() + 1);
        this.writer.println("");
    }

    public void drawStringLine(String string) {
        this.movePoint(0, this.getPosY() + 1);
        this.writer.println(string);
    }

    public void drawSpace() {
        this.movePoint(this.getPosX() + 1, this.getPosY());
        this.writer.print(" ");
    }

    private void movePoint(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public int getPosX() {
        return this.x;
    }

    public int getPosY() {
        return this.y;
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
    }
}

