/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.sequencer;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.jack.sequencer.JackSequencer;
import org.herac.tuxguitar.jack.sequencer.JackTrack;
import org.herac.tuxguitar.player.base.MidiPlayerException;

public class JackTrackController {
    private List tracks;
    private JackSequencer sequencer;
    private boolean anySolo;

    public JackTrackController(JackSequencer jackSequencer) {
        this.sequencer = jackSequencer;
        this.tracks = new ArrayList();
        this.anySolo = false;
    }

    public void init(int n) {
        this.tracks.clear();
        for (int i = 0; i < n; ++i) {
            this.tracks.add(new JackTrack());
        }
    }

    public void clearTracks() {
        this.tracks.clear();
    }

    public void checkAnySolo() {
        this.anySolo = false;
        for (int i = 0; i < this.tracks.size(); ++i) {
            JackTrack jackTrack = (JackTrack)this.tracks.get(i);
            if (!jackTrack.isSolo()) continue;
            this.anySolo = true;
            break;
        }
    }

    public void setSolo(int n, boolean bl) throws MidiPlayerException {
        if (n >= 0 && n < this.tracks.size()) {
            JackTrack jackTrack = (JackTrack)this.tracks.get(n);
            jackTrack.setSolo(bl);
            this.checkAnySolo();
            if (jackTrack.isSolo()) {
                this.setMute(n, false);
                this.sequencer.getTransmitter().sendAllNotesOff();
            }
        }
    }

    public void setMute(int n, boolean bl) throws MidiPlayerException {
        if (n >= 0 && n < this.tracks.size()) {
            JackTrack jackTrack = (JackTrack)this.tracks.get(n);
            jackTrack.setMute(bl);
            if (jackTrack.isMute()) {
                this.setSolo(n, false);
                this.sequencer.getTransmitter().sendAllNotesOff();
            }
        }
    }

    public boolean isSolo(int n) {
        if (n >= 0 && n < this.tracks.size()) {
            JackTrack jackTrack = (JackTrack)this.tracks.get(n);
            return jackTrack.isSolo();
        }
        return false;
    }

    public boolean isMute(int n) {
        if (n >= 0 && n < this.tracks.size()) {
            JackTrack jackTrack = (JackTrack)this.tracks.get(n);
            return jackTrack.isMute();
        }
        return false;
    }

    public boolean isAnySolo() {
        return this.anySolo;
    }
}

