/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.sequencer;

import java.util.List;
import org.herac.tuxguitar.jack.sequencer.JackSequencer;

public class JackTickController {
    private int tempo;
    private long frame;
    private long lastFrame;
    private long tickLength;
    private double tick;
    private Object lock = new Object();
    private JackSequencer sequencer;

    public JackTickController(JackSequencer jackSequencer) {
        this.sequencer = jackSequencer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Object object = this.lock;
        synchronized (object) {
            long l = this.sequencer.getJackClient().getTransportFrameRate();
            this.lastFrame = this.frame;
            this.frame = this.sequencer.getJackClient().getTransportFrame();
            this.tick += 960.0 * ((double)this.getTempo() * (double)(this.frame - this.lastFrame) / 60.0) / (double)l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTick(long l, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            long l2 = this.sequencer.getJackClient().getTransportFrameRate();
            if (bl) {
                this.sequencer.getJackClient().setTransportFrame(Math.round(this.tickToFrame(l, l2)));
            }
            this.frame = this.sequencer.getJackClient().getTransportFrame();
            this.tick = this.frameToTick(this.frame, l2);
        }
    }

    public double getTick() {
        return this.tick;
    }

    public long getTickLength() {
        return this.tickLength;
    }

    public void clearTick() {
        this.tickLength = 0L;
    }

    public void notifyTick(long l) {
        this.tickLength = Math.max(this.tickLength, l);
    }

    public void setTempo(int n) {
        this.tempo = n;
    }

    public int getTempo() {
        return this.tempo;
    }

    public double frameToTick(long l, long l2) {
        double d;
        double d2 = 0.0;
        double d3 = 120.0;
        double d4 = 960.0;
        List list = this.sequencer.getJackEventController().getTempoChanges();
        for (int i = 0; i < list.size(); ++i) {
            long[] lArray = (long[])list.get(i);
            d = lArray[0];
            double d5 = lArray[1];
            double d6 = (double)l2 * (d - d4) / 960.0 * (60.0 / d3);
            if (!(d2 + d6 <= (double)l)) break;
            d2 += d6;
            d3 = d5;
            d4 = d;
        }
        if ((double)l > d2) {
            double d7 = ((double)l - d2) / (double)l2 * 1000.0;
            d = d7 * 960.0 / 1000.0;
            d4 += d * (d3 / 60.0);
        }
        return d4;
    }

    public double tickToFrame(long l, long l2) {
        double d;
        double d2 = 960.0;
        double d3 = 120.0;
        double d4 = 0.0;
        List list = this.sequencer.getJackEventController().getTempoChanges();
        for (int i = 0; i < list.size(); ++i) {
            long[] lArray = (long[])list.get(i);
            d = lArray[0];
            double d5 = lArray[1];
            double d6 = (double)l2 * (d - d2) / 960.0 * (60.0 / d3);
            if (!(d <= (double)l)) break;
            d4 += d6;
            d3 = d5;
            d2 = d;
        }
        if ((double)l > d2) {
            double d7 = ((double)l - d2) / 960.0 * 1000.0;
            d = d7 * (double)l2 / 1000.0;
            d4 += d * (60.0 / d3);
        }
        return d4;
    }
}

