/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.sequencer;

import org.herac.tuxguitar.jack.sequencer.JackEvent;
import org.herac.tuxguitar.jack.sequencer.JackSequencer;
import org.herac.tuxguitar.player.base.MidiPlayerException;

public class JackEventDispacher {
    private JackSequencer sequencer;

    public JackEventDispacher(JackSequencer jackSequencer) {
        this.sequencer = jackSequencer;
    }

    public void dispatch(JackEvent jackEvent) throws MidiPlayerException {
        if (jackEvent.getType() == 2) {
            this.sequencer.getTransmitter().sendNoteOn((int)jackEvent.getData()[0], (int)jackEvent.getData()[1], (int)jackEvent.getData()[2]);
        } else if (jackEvent.getType() == 3) {
            this.sequencer.getTransmitter().sendNoteOff((int)jackEvent.getData()[0], (int)jackEvent.getData()[1], (int)jackEvent.getData()[2]);
        } else if (jackEvent.getType() == 5) {
            this.sequencer.getTransmitter().sendControlChange((int)jackEvent.getData()[0], (int)jackEvent.getData()[1], (int)jackEvent.getData()[2]);
        } else if (jackEvent.getType() == 4) {
            this.sequencer.getTransmitter().sendProgramChange((int)jackEvent.getData()[0], (int)jackEvent.getData()[1]);
        } else if (jackEvent.getType() == 6) {
            this.sequencer.getTransmitter().sendPitchBend((int)jackEvent.getData()[0], (int)jackEvent.getData()[1]);
        } else if (jackEvent.getType() == 1 && jackEvent.getData()[0] == 81) {
            int n = jackEvent.getData()[1] & 0xFF | (jackEvent.getData()[2] & 0xFF) << 8 | (jackEvent.getData()[3] & 0xFF) << 16;
            this.sequencer.setTempo((int)(60000.0 / ((double)n / 1000.0)));
        }
    }
}

