/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.system.plugins.TGPluginException;
import org.herac.tuxguitar.gui.system.plugins.TGPluginSetup;
import org.herac.tuxguitar.gui.system.plugins.base.TGPluginList;
import org.herac.tuxguitar.jack.JackClient;
import org.herac.tuxguitar.jack.sequencer.JackSequencerProviderPlugin;
import org.herac.tuxguitar.jack.settings.JackSettings;
import org.herac.tuxguitar.jack.settings.JackSettingsDialog;
import org.herac.tuxguitar.jack.synthesizer.JackOutputPortProviderPlugin;

public class JackPluginImpl
extends TGPluginList
implements TGPluginSetup {
    private JackClient jackClient = new JackClient();
    private JackSettings jackSettings = new JackSettings();

    protected List getPlugins() throws TGPluginException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add((Object)new JackOutputPortProviderPlugin(this.jackClient, this.jackSettings));
        arrayList.add((Object)new JackSequencerProviderPlugin(this.jackClient));
        return arrayList;
    }

    public void closeAll() {
        if (this.jackClient.isOpen()) {
            this.jackClient.close();
            this.jackClient.finalize();
        }
    }

    public String getAuthor() {
        return "Julian Casadesus <julian@casadesus.com.ar>";
    }

    public String getDescription() {
        return "Jack Audio Connection Kit plugin support";
    }

    public String getName() {
        return "Jack Audio Connection Kit plugin support";
    }

    public String getVersion() {
        return "1.0";
    }

    public void setupDialog(Shell shell) {
        JackSettingsDialog jackSettingsDialog = new JackSettingsDialog(this.jackSettings);
        jackSettingsDialog.open(shell);
    }
}

