/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.factory.TGFactory;

public abstract class TGDivisionType {
    public static final TGDivisionType NORMAL = TGDivisionType.newDivisionType(1, 1);
    private int enters = 1;
    private int times = 1;

    public int getEnters() {
        return this.enters;
    }

    public void setEnters(int n) {
        this.enters = n;
    }

    public int getTimes() {
        return this.times;
    }

    public void setTimes(int n) {
        this.times = n;
    }

    public long convertTime(long l) {
        return l * (long)this.times / (long)this.enters;
    }

    public boolean isEqual(TGDivisionType tGDivisionType) {
        return tGDivisionType.getEnters() == this.getEnters() && tGDivisionType.getTimes() == this.getTimes();
    }

    public TGDivisionType clone(TGFactory tGFactory) {
        TGDivisionType tGDivisionType = tGFactory.newDivisionType();
        this.copy(tGDivisionType);
        return tGDivisionType;
    }

    public void copy(TGDivisionType tGDivisionType) {
        tGDivisionType.setEnters(this.enters);
        tGDivisionType.setTimes(this.times);
    }

    private static TGDivisionType newDivisionType(int n, int n2) {
        TGDivisionType tGDivisionType = new TGFactory().newDivisionType();
        tGDivisionType.setEnters(n);
        tGDivisionType.setTimes(n2);
        return tGDivisionType;
    }
}

