/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;

public abstract class TGChord {
    private int firstFret;
    private int[] strings;
    private String name;
    private TGBeat beat;

    public TGChord(int n) {
        this.strings = new int[n];
        for (int i = 0; i < this.strings.length; ++i) {
            this.strings[i] = -1;
        }
    }

    public TGBeat getBeat() {
        return this.beat;
    }

    public void setBeat(TGBeat tGBeat) {
        this.beat = tGBeat;
    }

    public void addFretValue(int n, int n2) {
        if (n >= 0 && n < this.strings.length) {
            this.strings[n] = n2;
        }
    }

    public int getFretValue(int n) {
        if (n >= 0 && n < this.strings.length) {
            return this.strings[n];
        }
        return -1;
    }

    public int getFirstFret() {
        return this.firstFret;
    }

    public void setFirstFret(int n) {
        this.firstFret = n;
    }

    public int[] getStrings() {
        return this.strings;
    }

    public int countStrings() {
        return this.strings.length;
    }

    public int countNotes() {
        int n = 0;
        for (int i = 0; i < this.strings.length; ++i) {
            if (this.strings[i] < 0) continue;
            ++n;
        }
        return n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public TGChord clone(TGFactory tGFactory) {
        TGChord tGChord = tGFactory.newChord(this.strings.length);
        tGChord.setName(this.getName());
        tGChord.setFirstFret(this.getFirstFret());
        for (int i = 0; i < tGChord.strings.length; ++i) {
            tGChord.strings[i] = this.strings[i];
        }
        return tGChord;
    }
}

