/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGStroke;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGVoice;

public abstract class TGBeat {
    public static final int MAX_VOICES = 2;
    private long start = 960L;
    private TGMeasure measure;
    private TGChord chord;
    private TGText text;
    private TGVoice[] voices;
    private TGStroke stroke;

    public TGBeat(TGFactory tGFactory) {
        this.stroke = tGFactory.newStroke();
        this.voices = new TGVoice[2];
        for (int i = 0; i < 2; ++i) {
            this.setVoice(i, tGFactory.newVoice(i));
        }
    }

    public TGMeasure getMeasure() {
        return this.measure;
    }

    public void setMeasure(TGMeasure tGMeasure) {
        this.measure = tGMeasure;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long l) {
        this.start = l;
    }

    public void setVoice(int n, TGVoice tGVoice) {
        if (n >= 0 && n < this.voices.length) {
            this.voices[n] = tGVoice;
            this.voices[n].setBeat(this);
        }
    }

    public TGVoice getVoice(int n) {
        if (n >= 0 && n < this.voices.length) {
            return this.voices[n];
        }
        return null;
    }

    public int countVoices() {
        return this.voices.length;
    }

    public void setChord(TGChord tGChord) {
        this.chord = tGChord;
        this.chord.setBeat(this);
    }

    public TGChord getChord() {
        return this.chord;
    }

    public void removeChord() {
        this.chord = null;
    }

    public TGText getText() {
        return this.text;
    }

    public void setText(TGText tGText) {
        this.text = tGText;
        this.text.setBeat(this);
    }

    public void removeText() {
        this.text = null;
    }

    public boolean isChordBeat() {
        return this.chord != null;
    }

    public boolean isTextBeat() {
        return this.text != null;
    }

    public TGStroke getStroke() {
        return this.stroke;
    }

    public boolean isRestBeat() {
        for (int i = 0; i < this.countVoices(); ++i) {
            TGVoice tGVoice = this.getVoice(i);
            if (tGVoice.isEmpty() || tGVoice.isRestVoice()) continue;
            return false;
        }
        return true;
    }

    public TGBeat clone(TGFactory tGFactory) {
        TGBeat tGBeat = tGFactory.newBeat();
        tGBeat.setStart(this.getStart());
        this.getStroke().copy(tGBeat.getStroke());
        for (int i = 0; i < this.voices.length; ++i) {
            tGBeat.setVoice(i, this.voices[i].clone(tGFactory));
        }
        if (this.chord != null) {
            tGBeat.setChord(this.chord.clone(tGFactory));
        }
        if (this.text != null) {
            tGBeat.setText(this.text.clone(tGFactory));
        }
        return tGBeat;
    }
}

