/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.sequencer;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.impl.sequencer.MidiSequencerImpl;
import org.herac.tuxguitar.player.impl.sequencer.MidiTrack;

public class MidiTrackController {
    private List tracks;
    private MidiSequencerImpl sequencer;
    private boolean anySolo;

    public MidiTrackController(MidiSequencerImpl midiSequencerImpl) {
        this.sequencer = midiSequencerImpl;
        this.tracks = new ArrayList();
        this.anySolo = false;
    }

    public void init(int n) {
        this.tracks.clear();
        for (int i = 0; i < n; ++i) {
            this.tracks.add(new MidiTrack());
        }
    }

    public void clearTracks() {
        this.tracks.clear();
    }

    public void checkAnySolo() {
        this.anySolo = false;
        for (int i = 0; i < this.tracks.size(); ++i) {
            MidiTrack midiTrack = (MidiTrack)this.tracks.get(i);
            if (!midiTrack.isSolo()) continue;
            this.anySolo = true;
            break;
        }
    }

    public void setSolo(int n, boolean bl) throws MidiPlayerException {
        if (n >= 0 && n < this.tracks.size()) {
            MidiTrack midiTrack = (MidiTrack)this.tracks.get(n);
            midiTrack.setSolo(bl);
            this.checkAnySolo();
            if (midiTrack.isSolo()) {
                this.setMute(n, false);
                this.sequencer.getTransmitter().sendAllNotesOff();
            }
        }
    }

    public void setMute(int n, boolean bl) throws MidiPlayerException {
        if (n >= 0 && n < this.tracks.size()) {
            MidiTrack midiTrack = (MidiTrack)this.tracks.get(n);
            midiTrack.setMute(bl);
            if (midiTrack.isMute()) {
                this.setSolo(n, false);
                this.sequencer.getTransmitter().sendAllNotesOff();
            }
        }
    }

    public boolean isSolo(int n) {
        if (n >= 0 && n < this.tracks.size()) {
            MidiTrack midiTrack = (MidiTrack)this.tracks.get(n);
            return midiTrack.isSolo();
        }
        return false;
    }

    public boolean isMute(int n) {
        if (n >= 0 && n < this.tracks.size()) {
            MidiTrack midiTrack = (MidiTrack)this.tracks.get(n);
            return midiTrack.isMute();
        }
        return false;
    }

    public boolean isAnySolo() {
        return this.anySolo;
    }
}

