/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.base;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiReceiver;

public class MidiTransmitter {
    private List receivers = new ArrayList();

    public void sendSystemReset() throws MidiPlayerException {
        for (int i = 0; i < this.receivers.size(); ++i) {
            MidiReceiverItem midiReceiverItem = (MidiReceiverItem)this.receivers.get(i);
            midiReceiverItem.getReceiver().sendSystemReset();
        }
    }

    public void sendAllNotesOff() throws MidiPlayerException {
        for (int i = 0; i < this.receivers.size(); ++i) {
            MidiReceiverItem midiReceiverItem = (MidiReceiverItem)this.receivers.get(i);
            midiReceiverItem.getReceiver().sendAllNotesOff();
        }
    }

    public void sendNoteOn(int n, int n2, int n3) throws MidiPlayerException {
        for (int i = 0; i < this.receivers.size(); ++i) {
            MidiReceiverItem midiReceiverItem = (MidiReceiverItem)this.receivers.get(i);
            midiReceiverItem.getReceiver().sendNoteOn(n, n2, n3);
        }
    }

    public void sendNoteOff(int n, int n2, int n3) throws MidiPlayerException {
        for (int i = 0; i < this.receivers.size(); ++i) {
            MidiReceiverItem midiReceiverItem = (MidiReceiverItem)this.receivers.get(i);
            midiReceiverItem.getReceiver().sendNoteOff(n, n2, n3);
        }
    }

    public void sendProgramChange(int n, int n2) throws MidiPlayerException {
        for (int i = 0; i < this.receivers.size(); ++i) {
            MidiReceiverItem midiReceiverItem = (MidiReceiverItem)this.receivers.get(i);
            midiReceiverItem.getReceiver().sendProgramChange(n, n2);
        }
    }

    public void sendControlChange(int n, int n2, int n3) throws MidiPlayerException {
        for (int i = 0; i < this.receivers.size(); ++i) {
            MidiReceiverItem midiReceiverItem = (MidiReceiverItem)this.receivers.get(i);
            midiReceiverItem.getReceiver().sendControlChange(n, n2, n3);
        }
    }

    public void sendPitchBend(int n, int n2) throws MidiPlayerException {
        for (int i = 0; i < this.receivers.size(); ++i) {
            MidiReceiverItem midiReceiverItem = (MidiReceiverItem)this.receivers.get(i);
            midiReceiverItem.getReceiver().sendPitchBend(n, n2);
        }
    }

    public void addReceiver(String string, MidiReceiver midiReceiver) {
        MidiReceiverItem midiReceiverItem = this.getReceiver(string);
        if (midiReceiverItem == null) {
            this.receivers.add(new MidiReceiverItem(string, midiReceiver));
        }
    }

    public void removeReceiver(String string) {
        MidiReceiverItem midiReceiverItem = this.getReceiver(string);
        if (midiReceiverItem != null) {
            this.receivers.remove(midiReceiverItem);
        }
    }

    private MidiReceiverItem getReceiver(String string) {
        if (string != null) {
            for (int i = 0; i < this.receivers.size(); ++i) {
                MidiReceiverItem midiReceiverItem = (MidiReceiverItem)this.receivers.get(i);
                if (midiReceiverItem.getId() == null || !midiReceiverItem.getId().equals(string)) continue;
                return midiReceiverItem;
            }
        }
        return null;
    }

    private class MidiReceiverItem {
        private String id;
        private MidiReceiver receiver;

        public MidiReceiverItem(String string, MidiReceiver midiReceiver) {
            this.id = string;
            this.receiver = midiReceiver;
        }

        public String getId() {
            return this.id;
        }

        public MidiReceiver getReceiver() {
            return this.receiver;
        }
    }
}

