/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.base;

public class MidiPlayerMode {
    public static final int DEFAULT_TEMPO_PERCENT = 100;
    public static final int TYPE_SIMPLE = 1;
    public static final int TYPE_CUSTOM = 2;
    private int type;
    private boolean loop;
    private int loopSHeader;
    private int loopEHeader;
    private int simplePercent;
    private int customPercentFrom;
    private int customPercentTo;
    private int customPercentIncrement;
    private int currentPercent;

    public MidiPlayerMode() {
        this.clear();
    }

    public void clear() {
        this.loop = false;
        this.type = 1;
        this.simplePercent = 100;
        this.customPercentFrom = 100;
        this.customPercentTo = 100;
        this.customPercentIncrement = 0;
        this.loopSHeader = -1;
        this.loopEHeader = -1;
        this.reset();
    }

    public void reset() {
        if (this.getType() == 1) {
            this.setCurrentPercent(this.getSimplePercent());
        } else if (this.getType() == 2) {
            this.setCurrentPercent(this.getCustomPercentFrom());
        }
    }

    public void notifyLoop() {
        if (this.getType() == 1) {
            this.setCurrentPercent(this.getSimplePercent());
        } else if (this.getType() == 2) {
            this.setCurrentPercent(Math.min(this.getCustomPercentTo(), this.getCurrentPercent() + this.getCustomPercentIncrement()));
        }
    }

    public int getCurrentPercent() {
        return this.currentPercent;
    }

    public void setCurrentPercent(int n) {
        this.currentPercent = n;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean bl) {
        this.loop = bl;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getCustomPercentFrom() {
        return this.customPercentFrom;
    }

    public void setCustomPercentFrom(int n) {
        this.customPercentFrom = n;
    }

    public int getCustomPercentIncrement() {
        return this.customPercentIncrement;
    }

    public void setCustomPercentIncrement(int n) {
        this.customPercentIncrement = n;
    }

    public int getCustomPercentTo() {
        return this.customPercentTo;
    }

    public void setCustomPercentTo(int n) {
        this.customPercentTo = n;
    }

    public int getSimplePercent() {
        return this.simplePercent;
    }

    public void setSimplePercent(int n) {
        this.simplePercent = n;
    }

    public int getLoopSHeader() {
        return this.loopSHeader;
    }

    public void setLoopSHeader(int n) {
        this.loopSHeader = n;
    }

    public int getLoopEHeader() {
        return this.loopEHeader;
    }

    public void setLoopEHeader(int n) {
        this.loopEHeader = n;
    }
}

