/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import java.io.File;
import java.net.URL;
import org.herac.tuxguitar.util.TGVersion;

public class ArgumentParser {
    private static final String TG_DEFAULT_URL = "tuxguitar.default.url";
    private static final String[] OPTION_HELP = new String[]{"-h", "--help"};
    private static final String[] OPTION_VERSION = new String[]{"-v", "--version"};
    private static final String[] OPTION_JRE_INFO = new String[]{"-i", "--system-info"};
    private String[] arguments;
    private boolean processAndExit;
    private URL url;

    public ArgumentParser(String[] stringArray) {
        this.arguments = stringArray;
        this.processAndExit = false;
        this.parse();
    }

    private void parse() {
        try {
            this.checkHelp();
            this.checkVersion();
            this.checkSystemInfo();
            if (!this.processAndExit()) {
                this.checkProperties();
                this.checkURL();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void checkHelp() {
        for (int i = 0; i < this.arguments.length; ++i) {
            for (int j = 0; j < OPTION_HELP.length; ++j) {
                if (!this.arguments[i].equals(OPTION_HELP[j])) continue;
                this.print("usage: TuxGuitar [file]");
                this.print("Options:");
                this.print("\t-h, --help                 Show help options");
                this.print("\t-v, --version              Show version information and exit");
                this.print("\t-i, --system-info          Show the JVM system information");
                this.print("\t-D<name>=<value>           Set a JVM system property");
                this.processAndExit = true;
            }
        }
    }

    private void checkVersion() {
        for (int i = 0; i < this.arguments.length; ++i) {
            for (int j = 0; j < OPTION_VERSION.length; ++j) {
                if (!this.arguments[i].equals(OPTION_VERSION[j])) continue;
                this.print("TuxGuitar - " + TGVersion.CURRENT.getVersion());
                this.processAndExit = true;
            }
        }
    }

    private void checkSystemInfo() {
        for (int i = 0; i < this.arguments.length; ++i) {
            for (int j = 0; j < OPTION_JRE_INFO.length; ++j) {
                if (!this.arguments[i].equals(OPTION_JRE_INFO[j])) continue;
                this.print("System Info:");
                this.print("-> OS-Name:           " + System.getProperty("os.name"));
                this.print("-> OS-Arch:           " + System.getProperty("os.arch"));
                this.print("-> OS-Version:        " + System.getProperty("os.version"));
                this.print("-> JVM-Name:          " + System.getProperty("java.vm.name"));
                this.print("-> JVM-Version:       " + System.getProperty("java.vm.version"));
                this.print("-> JVM-Vendor:        " + System.getProperty("java.vm.vendor"));
                this.print("-> Java-Version:      " + System.getProperty("java.version"));
                this.print("-> Java-Vendor:       " + System.getProperty("java.vendor"));
                this.print("-> Java-Home:         " + System.getProperty("java.home"));
                this.print("-> Java-Class-Path:   " + System.getProperty("java.class.path"));
                this.print("-> Java-Library-Path: " + System.getProperty("java.library.path"));
                this.processAndExit = true;
            }
        }
    }

    private void checkProperties() {
        for (int i = 0; i < this.arguments.length; ++i) {
            int n = this.arguments[i].indexOf("-D");
            int n2 = this.arguments[i].indexOf("=");
            if (n != 0 || n2 <= n || n2 + 1 >= this.arguments[i].length()) continue;
            String string = this.arguments[i].substring(2, n2);
            String string2 = this.arguments[i].substring(n2 + 1);
            if (string == null || string.length() <= 0 || string2 == null || string2.length() <= 0) continue;
            System.setProperty(string, string2);
        }
    }

    private void checkURL() {
        String string = System.getProperty(TG_DEFAULT_URL);
        if (string != null && this.makeURL(string)) {
            return;
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            if (!this.makeURL(this.arguments[i])) continue;
            return;
        }
    }

    private boolean makeURL(String string) {
        try {
            File file = new File(string);
            this.url = file.exists() ? file.toURI().toURL() : new URL(string);
        }
        catch (Throwable throwable) {
            this.url = null;
        }
        return this.url != null;
    }

    public boolean processAndExit() {
        return this.processAndExit;
    }

    public URL getURL() {
        return this.url;
    }

    protected void print(String string) {
        this.print(string, true);
    }

    protected void print(String string, boolean bl) {
        if (!bl || string != null) {
            System.out.println(string);
        }
    }
}

