/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGTrack;

public class UndoableTrackSoloMute
implements UndoableEdit {
    private int doAction;
    private int track;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private boolean undoSolo;
    private boolean undoMute;
    private boolean redoSolo;
    private boolean redoMute;

    private UndoableTrackSoloMute() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        TGTrack tGTrack = tGSongManager.getTrack(this.track);
        if (tGTrack != null) {
            tGSongManager.getTrackManager().changeSolo(tGTrack, this.redoSolo);
            tGSongManager.getTrackManager().changeMute(tGTrack, this.redoMute);
        }
        TuxGuitar.instance().getMixer().updateValues();
        TuxGuitar.instance().getTable().fireUpdate(false);
        TuxGuitar.instance().updateCache(true);
        if (TuxGuitar.instance().getPlayer().isRunning()) {
            TuxGuitar.instance().getPlayer().updateControllers();
        }
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        TGTrack tGTrack = tGSongManager.getTrack(this.track);
        if (tGTrack != null) {
            tGSongManager.getTrackManager().changeSolo(tGTrack, this.undoSolo);
            tGSongManager.getTrackManager().changeMute(tGTrack, this.undoMute);
        }
        TuxGuitar.instance().getMixer().updateValues();
        TuxGuitar.instance().getTable().fireUpdate(false);
        TuxGuitar.instance().updateCache(true);
        if (TuxGuitar.instance().getPlayer().isRunning()) {
            TuxGuitar.instance().getPlayer().updateControllers();
        }
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableTrackSoloMute startUndo(TGTrack tGTrack) {
        UndoableTrackSoloMute undoableTrackSoloMute = new UndoableTrackSoloMute();
        undoableTrackSoloMute.doAction = 1;
        undoableTrackSoloMute.undoCaret = new UndoableCaretHelper();
        undoableTrackSoloMute.track = tGTrack.getNumber();
        undoableTrackSoloMute.undoSolo = tGTrack.isSolo();
        undoableTrackSoloMute.undoMute = tGTrack.isMute();
        return undoableTrackSoloMute;
    }

    public UndoableTrackSoloMute endUndo(TGTrack tGTrack) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoSolo = tGTrack.isSolo();
        this.redoMute = tGTrack.isMute();
        return this;
    }
}

