/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGTrack;

public class UndoableTrackInstrument
implements UndoableEdit {
    private int doAction;
    private int trackNumber;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private short undoInstrument;
    private short redoInstrument;
    private boolean undoPercussion;
    private boolean redoPercussion;

    private UndoableTrackInstrument() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        tGSongManager.getTrackManager().changeInstrument(tGSongManager.getTrack(this.trackNumber), this.redoInstrument, this.redoPercussion);
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().updateValues();
        if (TuxGuitar.instance().getPlayer().isRunning()) {
            TuxGuitar.instance().getPlayer().updatePrograms();
        }
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        tGSongManager.getTrackManager().changeInstrument(tGSongManager.getTrack(this.trackNumber), this.undoInstrument, this.undoPercussion);
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().updateValues();
        if (TuxGuitar.instance().getPlayer().isRunning()) {
            TuxGuitar.instance().getPlayer().updatePrograms();
        }
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableTrackInstrument startUndo(TGTrack tGTrack) {
        UndoableTrackInstrument undoableTrackInstrument = new UndoableTrackInstrument();
        undoableTrackInstrument.doAction = 1;
        undoableTrackInstrument.undoCaret = new UndoableCaretHelper();
        undoableTrackInstrument.trackNumber = tGTrack.getNumber();
        undoableTrackInstrument.undoInstrument = tGTrack.getChannel().getInstrument();
        undoableTrackInstrument.undoPercussion = tGTrack.isPercussionTrack();
        return undoableTrackInstrument;
    }

    public UndoableTrackInstrument endUndo(TGTrack tGTrack) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoInstrument = tGTrack.getChannel().getInstrument();
        this.redoPercussion = tGTrack.isPercussionTrack();
        return this;
    }
}

