/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.TGTrack;

public class UndoableTrackGeneric
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private UndoTrack undoTrack;
    private RedoTrack redoTrack;

    private UndoableTrackGeneric() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.redoTrack.redo();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.undoTrack.undo();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableTrackGeneric startUndo(TGTrack tGTrack) {
        UndoableTrackGeneric undoableTrackGeneric = new UndoableTrackGeneric();
        undoableTrackGeneric.doAction = 1;
        undoableTrackGeneric.undoCaret = new UndoableCaretHelper();
        UndoableTrackGeneric undoableTrackGeneric2 = undoableTrackGeneric;
        undoableTrackGeneric2.getClass();
        undoableTrackGeneric.undoTrack = undoableTrackGeneric2.new UndoTrack(tGTrack);
        return undoableTrackGeneric;
    }

    public UndoableTrackGeneric endUndo(TGTrack tGTrack) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoTrack = new RedoTrack(tGTrack);
        return this;
    }

    private class RedoTrack {
        private TGTrack track;

        public RedoTrack(TGTrack tGTrack) {
            if (tGTrack != null) {
                this.track = tGTrack.clone(TuxGuitar.instance().getSongManager().getFactory(), TuxGuitar.instance().getSongManager().getSong());
            }
        }

        public void redo() {
            if (this.track != null) {
                while (TuxGuitar.instance().getSongManager().getSong().countMeasureHeaders() < this.track.countMeasures()) {
                    TuxGuitar.instance().getSongManager().addNewMeasureBeforeEnd();
                }
                while (TuxGuitar.instance().getSongManager().getSong().countMeasureHeaders() > this.track.countMeasures()) {
                    TuxGuitar.instance().getSongManager().removeLastMeasureHeader();
                }
                TuxGuitar.instance().getSongManager().replaceTrack(this.track);
                TuxGuitar.instance().fireUpdate();
                TuxGuitar.instance().getMixer().update();
            }
        }
    }

    private class UndoTrack {
        private TGTrack track;

        public UndoTrack(TGTrack tGTrack) {
            if (tGTrack != null) {
                this.track = tGTrack.clone(TuxGuitar.instance().getSongManager().getFactory(), TuxGuitar.instance().getSongManager().getSong());
            }
        }

        public void undo() {
            if (this.track != null) {
                while (TuxGuitar.instance().getSongManager().getSong().countMeasureHeaders() < this.track.countMeasures()) {
                    TuxGuitar.instance().getSongManager().addNewMeasureBeforeEnd();
                }
                while (TuxGuitar.instance().getSongManager().getSong().countMeasureHeaders() > this.track.countMeasures()) {
                    TuxGuitar.instance().getSongManager().removeLastMeasureHeader();
                }
                TuxGuitar.instance().getSongManager().replaceTrack(this.track);
                TuxGuitar.instance().fireUpdate();
                TuxGuitar.instance().getMixer().update();
            }
        }
    }
}

