/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.measure;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGTrack;

public class UndoableMeasureGeneric
implements UndoableEdit {
    private int doAction;
    private int trackNumber;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private TGMeasure undoMeasure;
    private TGMeasure redoMeasure;

    private UndoableMeasureGeneric() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.replace(this.redoMeasure);
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.replace(this.undoMeasure);
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    private void replace(TGMeasure tGMeasure) {
        TGTrack tGTrack = TuxGuitar.instance().getSongManager().getTrack(this.trackNumber);
        if (tGTrack != null && tGMeasure != null) {
            TGMeasureHeader tGMeasureHeader = TuxGuitar.instance().getSongManager().getMeasureHeader(tGMeasure.getNumber());
            TGMeasure tGMeasure2 = tGMeasure.clone(TuxGuitar.instance().getSongManager().getFactory(), tGMeasureHeader);
            tGMeasure2 = TuxGuitar.instance().getSongManager().getTrackManager().replaceMeasure(tGTrack, tGMeasure2);
            TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(tGMeasure2.getNumber());
        }
    }

    public static UndoableMeasureGeneric startUndo(TGMeasure tGMeasure) {
        UndoableMeasureGeneric undoableMeasureGeneric = new UndoableMeasureGeneric();
        undoableMeasureGeneric.doAction = 1;
        undoableMeasureGeneric.trackNumber = tGMeasure.getTrack().getNumber();
        undoableMeasureGeneric.undoCaret = new UndoableCaretHelper();
        undoableMeasureGeneric.undoMeasure = tGMeasure.clone(TuxGuitar.instance().getSongManager().getFactory(), tGMeasure.getHeader().clone(TuxGuitar.instance().getSongManager().getFactory()));
        return undoableMeasureGeneric;
    }

    public UndoableMeasureGeneric endUndo(TGMeasure tGMeasure) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoMeasure = tGMeasure.clone(TuxGuitar.instance().getSongManager().getFactory(), tGMeasure.getHeader().clone(TuxGuitar.instance().getSongManager().getFactory()));
        return this;
    }

    public static UndoableMeasureGeneric startUndo() {
        return UndoableMeasureGeneric.startUndo(UndoableMeasureGeneric.getCaret().getMeasure());
    }

    public UndoableMeasureGeneric endUndo() {
        return this.endUndo(UndoableMeasureGeneric.getCaret().getMeasure());
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

