/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.custom;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTimeSignature;

public class UndoableChangeTimeSignature
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private TGSong song;
    private long tsStart;
    private boolean tsToEnd;
    private TGTimeSignature ts;

    private UndoableChangeTimeSignature() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getTablatureEditor().getTablature().getSongManager().changeTimeSignature(this.tsStart, this.ts, this.tsToEnd);
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TGFactory tGFactory = TuxGuitar.instance().getTablatureEditor().getTablature().getSongManager().getFactory();
        TGSong tGSong = TuxGuitar.instance().getTablatureEditor().getTablature().getSongManager().getSong();
        this.song.copy(tGFactory, tGSong);
        TuxGuitar.instance().fireUpdate();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableChangeTimeSignature startUndo() {
        TGFactory tGFactory = new TGFactory();
        TGSong tGSong = TuxGuitar.instance().getTablatureEditor().getTablature().getSongManager().getSong();
        UndoableChangeTimeSignature undoableChangeTimeSignature = new UndoableChangeTimeSignature();
        undoableChangeTimeSignature.doAction = 1;
        undoableChangeTimeSignature.undoCaret = new UndoableCaretHelper();
        undoableChangeTimeSignature.song = tGSong.clone(tGFactory);
        return undoableChangeTimeSignature;
    }

    public UndoableChangeTimeSignature endUndo(TGTimeSignature tGTimeSignature, long l, boolean bl) {
        this.ts = tGTimeSignature;
        this.tsStart = l;
        this.tsToEnd = bl;
        this.redoCaret = new UndoableCaretHelper();
        return this;
    }
}

