/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.custom;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.marker.MarkerList;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.TGMarker;

public class UndoableChangeMarker
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private TGMarker undoMarker;
    private TGMarker redoMarker;

    private UndoableChangeMarker() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        if (this.redoMarker != null) {
            TuxGuitar.instance().getSongManager().updateMarker(this.redoMarker.clone(TuxGuitar.instance().getSongManager().getFactory()));
            MarkerList.instance().update(true);
        } else if (this.undoMarker != null) {
            TuxGuitar.instance().getSongManager().removeMarker(this.undoMarker.clone(TuxGuitar.instance().getSongManager().getFactory()));
            MarkerList.instance().update(false);
        }
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        if (this.undoMarker != null) {
            TuxGuitar.instance().getSongManager().updateMarker(this.undoMarker.clone(TuxGuitar.instance().getSongManager().getFactory()));
            MarkerList.instance().update(true);
        } else if (this.redoMarker != null) {
            TuxGuitar.instance().getSongManager().removeMarker(this.redoMarker.clone(TuxGuitar.instance().getSongManager().getFactory()));
            MarkerList.instance().update(false);
        }
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableChangeMarker startUndo(TGMarker tGMarker) {
        UndoableChangeMarker undoableChangeMarker = new UndoableChangeMarker();
        undoableChangeMarker.doAction = 1;
        undoableChangeMarker.undoCaret = new UndoableCaretHelper();
        undoableChangeMarker.undoMarker = tGMarker == null ? null : tGMarker.clone(TuxGuitar.instance().getSongManager().getFactory());
        return undoableChangeMarker;
    }

    public UndoableChangeMarker endUndo(TGMarker tGMarker) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoMarker = tGMarker == null ? null : tGMarker.clone(TuxGuitar.instance().getSongManager().getFactory());
        return this;
    }
}

