/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.custom;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGMeasure;

public class UndoableChangeCloseRepeat
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private long position;
    private int undoRepeatClose;
    private int redoRepeatClose;

    private UndoableChangeCloseRepeat() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        tGSongManager.changeCloseRepeat(this.position, this.redoRepeatClose);
        TGMeasure tGMeasure = tGSongManager.getTrackManager().getMeasureAt(tGSongManager.getFirstTrack(), this.position);
        TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(tGMeasure.getNumber());
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        tGSongManager.changeCloseRepeat(this.position, this.undoRepeatClose);
        TGMeasure tGMeasure = tGSongManager.getTrackManager().getMeasureAt(tGSongManager.getFirstTrack(), this.position);
        TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(tGMeasure.getNumber());
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableChangeCloseRepeat startUndo() {
        Caret caret = UndoableChangeCloseRepeat.getCaret();
        return UndoableChangeCloseRepeat.startUndo(caret.getPosition(), caret.getMeasure().getRepeatClose());
    }

    public static UndoableChangeCloseRepeat startUndo(long l, int n) {
        UndoableChangeCloseRepeat undoableChangeCloseRepeat = new UndoableChangeCloseRepeat();
        undoableChangeCloseRepeat.doAction = 1;
        undoableChangeCloseRepeat.undoCaret = new UndoableCaretHelper();
        undoableChangeCloseRepeat.position = l;
        undoableChangeCloseRepeat.undoRepeatClose = n;
        return undoableChangeCloseRepeat;
    }

    public UndoableChangeCloseRepeat endUndo(int n) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoRepeatClose = n;
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
}

