/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.browser.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserCollection;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TGBrowserWriter {
    private static final String ITEM_LIST_TAG = "browser-collections";
    private static final String ITEM_TAG = "browser-collection";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_DATA = "data";

    public void saveCollections(TGBrowserManager tGBrowserManager, String string) {
        try {
            Document document = TGBrowserWriter.createDocument();
            TGBrowserWriter.saveCollections(tGBrowserManager, document);
            TGBrowserWriter.saveDocument(document, new File(string));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void saveCollections(TGBrowserManager tGBrowserManager, Document document) {
        Element element = document.createElement(ITEM_LIST_TAG);
        Iterator iterator = tGBrowserManager.getCollections();
        while (iterator.hasNext()) {
            TGBrowserCollection tGBrowserCollection = (TGBrowserCollection)iterator.next();
            Element element2 = document.createElement(ITEM_TAG);
            element.appendChild(element2);
            Attr attr = document.createAttribute(ATTRIBUTE_TYPE);
            attr.setNodeValue(tGBrowserCollection.getType());
            Attr attr2 = document.createAttribute(ATTRIBUTE_DATA);
            attr2.setNodeValue(tGBrowserCollection.getData().toString());
            element2.getAttributes().setNamedItem(attr);
            element2.getAttributes().setNamedItem(attr2);
        }
        document.appendChild(element);
    }

    public static Document createDocument() {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return document;
    }

    public static void saveDocument(Document document, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(fileOutputStream);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }
}

