/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.browser.dialog;

import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserCollection;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserManager;
import org.herac.tuxguitar.gui.tools.browser.base.TGBrowserFactory;
import org.herac.tuxguitar.gui.tools.browser.dialog.TGBrowserBar;
import org.herac.tuxguitar.gui.tools.browser.dialog.TGBrowserCollectionCombo;
import org.herac.tuxguitar.gui.tools.browser.dialog.TGBrowserDialog;

public class TGBrowserToolBar
extends TGBrowserBar {
    private Composite composite;
    private ToolBar toolBar;
    private ToolItem newBrowser;
    private ToolItem root;
    private ToolItem back;
    private ToolItem refresh;
    protected Menu newBrowserMenu;
    protected TGBrowserCollectionCombo collections;

    public TGBrowserToolBar(TGBrowserDialog tGBrowserDialog) {
        super(tGBrowserDialog);
    }

    public void init(Shell shell) {
        this.composite = new Composite((Composite)shell, 0);
        this.composite.setLayout((Layout)this.getLayout());
        this.composite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.initItems();
    }

    public void initItems() {
        this.toolBar = new ToolBar(this.composite, 0x800040);
        this.newBrowserMenu = new Menu((Control)this.composite);
        Iterator iterator = TGBrowserManager.instance().getFactories();
        while (iterator.hasNext()) {
            final TGBrowserFactory tGBrowserFactory = (TGBrowserFactory)iterator.next();
            MenuItem menuItem = new MenuItem(this.newBrowserMenu, 8);
            menuItem.setText(tGBrowserFactory.getName());
            menuItem.setData((Object)tGBrowserFactory);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TGBrowserToolBar.this.newCollection(tGBrowserFactory.getType());
                }
            });
        }
        this.newBrowser = new ToolItem(this.toolBar, 4);
        this.newBrowser.setImage(TuxGuitar.instance().getIconManager().getBrowserNew());
        this.newBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.detail == 4) {
                    ToolItem toolItem = (ToolItem)selectionEvent.widget;
                    Rectangle rectangle = toolItem.getBounds();
                    Point point = toolItem.getParent().toDisplay(new Point(rectangle.x, rectangle.y));
                    TGBrowserToolBar.this.newBrowserMenu.setLocation(point.x, point.y + rectangle.height);
                    TGBrowserToolBar.this.newBrowserMenu.setVisible(true);
                }
            }
        });
        new ToolItem(this.toolBar, 2);
        this.root = new ToolItem(this.toolBar, 8);
        this.root.setImage(TuxGuitar.instance().getIconManager().getBrowserRoot());
        this.root.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGBrowserToolBar.this.getBrowser().getConnection().cdRoot(3);
            }
        });
        this.back = new ToolItem(this.toolBar, 8);
        this.back.setImage(TuxGuitar.instance().getIconManager().getBrowserBack());
        this.back.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGBrowserToolBar.this.getBrowser().getConnection().cdUp(4);
            }
        });
        this.refresh = new ToolItem(this.toolBar, 8);
        this.refresh.setImage(TuxGuitar.instance().getIconManager().getBrowserRefresh());
        this.refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGBrowserToolBar.this.getBrowser().getConnection().listElements(5);
            }
        });
        new ToolItem(this.toolBar, 2);
        this.collections = new TGBrowserCollectionCombo(this.composite, 8);
        this.collections.setLayoutData(new GridData(4, 0x1000000, true, true));
        this.collections.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGBrowserToolBar.this.updateCollection();
            }
        });
    }

    public void updateItems() {
        this.newBrowser.setEnabled(!this.getBrowser().getConnection().isLocked());
        this.collections.setEnabled(!this.getBrowser().getConnection().isLocked());
        this.root.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.back.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
        this.refresh.setEnabled(!this.getBrowser().getConnection().isLocked() && this.getBrowser().getConnection().isOpen());
    }

    public void updateCollections(TGBrowserCollection tGBrowserCollection) {
        int n = 0;
        this.collections.removeAll();
        Iterator iterator = TGBrowserManager.instance().getCollections();
        while (iterator.hasNext()) {
            TGBrowserCollection tGBrowserCollection2 = (TGBrowserCollection)iterator.next();
            if (tGBrowserCollection2.getData() == null) continue;
            this.collections.add(tGBrowserCollection2);
            if (tGBrowserCollection != null && tGBrowserCollection.equals(tGBrowserCollection2)) {
                this.collections.select(n);
            }
            ++n;
        }
    }

    public void reload() {
        this.disposeItems();
        this.initItems();
        this.loadProperties();
        this.updateItems();
        this.composite.layout(true, true);
    }

    public void loadProperties() {
        this.newBrowser.setToolTipText(TuxGuitar.getProperty("browser.collection.new"));
        this.root.setToolTipText(TuxGuitar.getProperty("browser.go-root"));
        this.back.setToolTipText(TuxGuitar.getProperty("browser.go-back"));
        this.refresh.setToolTipText(TuxGuitar.getProperty("browser.refresh"));
        this.updateCollections(this.getBrowser().getCollection());
    }

    protected void updateCollection() {
        TGBrowserCollection tGBrowserCollection = this.collections.getSelection();
        if (tGBrowserCollection == null) {
            this.closeCollection();
        } else {
            this.openCollection(tGBrowserCollection);
        }
    }

    private void disposeItems() {
        Control[] controlArray = this.composite.getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].dispose();
        }
    }

    private GridLayout getLayout() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        return gridLayout;
    }
}

