/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.gui.table.TGTableColumn;
import org.herac.tuxguitar.gui.table.TGTableRow;

public class TGTable {
    private ScrolledComposite sComposite;
    private Composite table;
    private SashForm columnControl;
    private Composite rowControl;
    private TGTableColumn columnNumber;
    private TGTableColumn columnName;
    private TGTableColumn columnInstrument;
    private TGTableColumn columnCanvas;
    private List rows = new ArrayList();
    private int rowHeight;
    private int scrollIncrement;

    public TGTable(Composite composite) {
        this.newTable(composite);
    }

    public void newTable(Composite composite) {
        this.sComposite = new ScrolledComposite(composite, 2560);
        this.sComposite.setLayout((Layout)new GridLayout());
        this.sComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sComposite.setAlwaysShowScrollBars(true);
        this.sComposite.setExpandHorizontal(true);
        this.sComposite.setExpandVertical(true);
        this.table = new Composite((Composite)this.sComposite, 0);
        this.table.setLayout((Layout)this.newGridLayout(1, 0, 0, 0, 0));
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.columnControl = new SashForm(this.table, 256);
        this.columnControl.setLayoutData((Object)new GridData(4, 128, true, false));
        this.columnNumber = new TGTableColumn(this, 16384);
        this.columnName = new TGTableColumn(this, 16384);
        this.columnInstrument = new TGTableColumn(this, 16384);
        this.columnCanvas = new TGTableColumn(this, 0x1000000);
        this.columnControl.setWeights(new int[]{1, 7, 7, 20});
        this.rowControl = new Composite(this.table, 0);
        this.rowControl.setLayout((Layout)this.newGridLayout(1, 0, 1, 0, 1));
        this.rowControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sComposite.setContent((Control)this.table);
    }

    public Composite getControl() {
        return this.table;
    }

    public void newRow() {
        this.rows.add(new TGTableRow(this));
    }

    private GridLayout newGridLayout(int n, int n2, int n3, int n4, int n5) {
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.marginWidth = n2;
        gridLayout.marginHeight = n3;
        gridLayout.horizontalSpacing = n4;
        gridLayout.verticalSpacing = n5;
        return gridLayout;
    }

    public void addRowItem(TGTableColumn tGTableColumn, Control control, boolean bl) {
        if (bl) {
            this.scrollIncrement = this.rowHeight = Math.max(this.rowHeight, control.computeSize((int)-1, (int)-1).y);
        }
        tGTableColumn.addControl(control);
    }

    public int getMinHeight() {
        return this.sComposite.getMinHeight() + this.sComposite.getBorderWidth() * 2;
    }

    public Composite getColumnControl() {
        return this.columnControl;
    }

    public Composite getRowControl() {
        return this.rowControl;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getScrollIncrement() {
        return this.scrollIncrement;
    }

    public TGTableColumn getColumnInstrument() {
        return this.columnInstrument;
    }

    public TGTableColumn getColumnName() {
        return this.columnName;
    }

    public TGTableColumn getColumnNumber() {
        return this.columnNumber;
    }

    public TGTableColumn getColumnCanvas() {
        return this.columnCanvas;
    }

    public TGTableRow getRow(int n) {
        if (n >= 0 && n < this.rows.size()) {
            return (TGTableRow)this.rows.get(n);
        }
        return null;
    }

    public void removeRowsAfter(int n) {
        while (n < this.rows.size()) {
            TGTableRow tGTableRow = (TGTableRow)this.rows.get(n);
            tGTableRow.dispose();
            this.rows.remove(n);
        }
        this.notifyRemoved();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public void update() {
        this.layoutColumns();
        this.table.layout(true, true);
        this.sComposite.setMinHeight(this.table.computeSize((int)-1, (int)-1).y);
        this.sComposite.getVerticalBar().setIncrement(this.getScrollIncrement() + this.sComposite.getBorderWidth());
    }

    private void notifyRemoved() {
        this.columnNumber.notifyRemoved();
        this.columnName.notifyRemoved();
        this.columnInstrument.notifyRemoved();
        this.columnCanvas.notifyRemoved();
    }

    private void layoutColumns() {
        this.columnNumber.layout();
        this.columnName.layout();
        this.columnInstrument.layout();
        this.columnCanvas.layout();
    }
}

