/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.plugins.base;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.plugins.TGPluginException;
import org.herac.tuxguitar.gui.system.plugins.base.TGPluginAdapter;
import org.herac.tuxguitar.player.base.MidiSequencerProvider;

public abstract class TGMidiSequencerProviderPlugin
extends TGPluginAdapter {
    private boolean loaded;
    private MidiSequencerProvider provider;

    protected abstract MidiSequencerProvider getProvider() throws TGPluginException;

    public void init() throws TGPluginException {
        this.provider = this.getProvider();
        this.loaded = false;
    }

    public void close() throws TGPluginException {
        try {
            this.provider.closeAll();
        }
        catch (Throwable throwable) {
            throw new TGPluginException(throwable.getMessage(), throwable);
        }
    }

    public void setEnabled(boolean bl) throws TGPluginException {
        if (bl) {
            this.addPlugin();
        } else {
            this.removePlugin();
        }
    }

    protected void addPlugin() throws TGPluginException {
        if (!this.loaded) {
            try {
                TuxGuitar.instance().getPlayer().addSequencerProvider(this.provider, TuxGuitar.instance().isInitialized());
                this.loaded = true;
            }
            catch (Throwable throwable) {
                throw new TGPluginException(throwable.getMessage(), throwable);
            }
        }
    }

    protected void removePlugin() throws TGPluginException {
        if (this.loaded) {
            try {
                TuxGuitar.instance().getPlayer().removeSequencerProvider(this.provider);
                this.loaded = false;
            }
            catch (Throwable throwable) {
                throw new TGPluginException(throwable.getMessage(), throwable);
            }
        }
    }
}

