/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.language;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.herac.tuxguitar.gui.util.TGFileUtils;

public class TGResourceBundle {
    private Locale locale;
    private Properties properties;

    public TGResourceBundle(Locale locale, Properties properties) {
        this.locale = locale;
        this.properties = properties;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getString(String string) {
        return this.properties.getProperty(string);
    }

    public static TGResourceBundle getBundle(String string, Locale locale) {
        Properties properties = new Properties();
        String string2 = string.replace('.', '/');
        String string3 = ".properties";
        TGResourceBundle.loadResources(string2 + string3, properties);
        string2 = string2 + "_";
        if (locale.getLanguage() != null && locale.getLanguage().length() > 0) {
            string2 = string2 + locale.getLanguage();
            TGResourceBundle.loadResources(string2 + string3, properties);
        }
        string2 = string2 + "_";
        if (locale.getCountry() != null && locale.getCountry().length() > 0) {
            string2 = string2 + locale.getCountry();
            TGResourceBundle.loadResources(string2 + string3, properties);
        }
        string2 = string2 + "_";
        if (locale.getVariant() != null && locale.getVariant().length() > 0) {
            string2 = string2 + locale.getVariant();
            TGResourceBundle.loadResources(string2 + string3, properties);
        }
        return new TGResourceBundle(locale, properties);
    }

    private static void loadResources(String string, Properties properties) {
        try {
            Enumeration enumeration = TGFileUtils.getResourceUrls(string);
            while (enumeration.hasMoreElements()) {
                URL uRL = (URL)enumeration.nextElement();
                Properties properties2 = new Properties();
                properties2.load(uRL.openStream());
                properties.putAll((Map<?, ?>)properties2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

