/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.song.models.TGNote;

public class NoteEffectsMenuItem
extends MenuItems {
    private MenuItem noteEffectsMenuItem;
    private Menu menu;
    private MenuItem vibrato;
    private MenuItem bend;
    private MenuItem tremoloBar;
    private MenuItem deadNote;
    private MenuItem slide;
    private MenuItem hammer;
    private MenuItem ghostNote;
    private MenuItem accentuatedNote;
    private MenuItem heavyAccentuatedNote;
    private MenuItem harmonicNote;
    private MenuItem graceNote;
    private MenuItem trill;
    private MenuItem tremoloPicking;
    private MenuItem palmMute;
    private MenuItem staccato;
    private MenuItem tapping;
    private MenuItem slapping;
    private MenuItem popping;
    private MenuItem fadeIn;

    public NoteEffectsMenuItem(Shell shell, Menu menu, int n) {
        this.noteEffectsMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.vibrato = new MenuItem(this.menu, 32);
        this.vibrato.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-vibrato"));
        this.bend = new MenuItem(this.menu, 32);
        this.bend.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-bend"));
        this.tremoloBar = new MenuItem(this.menu, 32);
        this.tremoloBar.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-tremolo-bar"));
        this.slide = new MenuItem(this.menu, 32);
        this.slide.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-slide"));
        this.deadNote = new MenuItem(this.menu, 32);
        this.deadNote.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-dead"));
        this.hammer = new MenuItem(this.menu, 32);
        this.hammer.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-hammer"));
        new MenuItem(this.menu, 2);
        this.ghostNote = new MenuItem(this.menu, 32);
        this.ghostNote.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-ghost"));
        this.accentuatedNote = new MenuItem(this.menu, 32);
        this.accentuatedNote.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-accentuated"));
        this.heavyAccentuatedNote = new MenuItem(this.menu, 32);
        this.heavyAccentuatedNote.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-heavy-accentuated"));
        this.harmonicNote = new MenuItem(this.menu, 32);
        this.harmonicNote.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-harmonic"));
        this.graceNote = new MenuItem(this.menu, 32);
        this.graceNote.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-grace"));
        new MenuItem(this.menu, 2);
        this.trill = new MenuItem(this.menu, 32);
        this.trill.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-trill"));
        this.tremoloPicking = new MenuItem(this.menu, 32);
        this.tremoloPicking.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-tremolo-picking"));
        this.palmMute = new MenuItem(this.menu, 32);
        this.palmMute.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-palm-mute"));
        this.staccato = new MenuItem(this.menu, 32);
        this.staccato.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-staccato"));
        new MenuItem(this.menu, 2);
        this.tapping = new MenuItem(this.menu, 32);
        this.tapping.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-tapping"));
        this.slapping = new MenuItem(this.menu, 32);
        this.slapping.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-slapping"));
        this.popping = new MenuItem(this.menu, 32);
        this.popping.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-popping"));
        new MenuItem(this.menu, 2);
        this.fadeIn = new MenuItem(this.menu, 32);
        this.fadeIn.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.effect.change-fade-in"));
        this.noteEffectsMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        TGNote tGNote = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getSelectedNote();
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        this.vibrato.setSelection(tGNote != null && tGNote.getEffect().isVibrato());
        this.vibrato.setEnabled(!bl && tGNote != null);
        this.bend.setSelection(tGNote != null && tGNote.getEffect().isBend());
        this.bend.setEnabled(!bl && tGNote != null);
        this.tremoloBar.setSelection(tGNote != null && tGNote.getEffect().isTremoloBar());
        this.tremoloBar.setEnabled(!bl && tGNote != null);
        this.deadNote.setSelection(tGNote != null && tGNote.getEffect().isDeadNote());
        this.deadNote.setEnabled(!bl && tGNote != null);
        this.slide.setSelection(tGNote != null && tGNote.getEffect().isSlide());
        this.slide.setEnabled(!bl && tGNote != null);
        this.hammer.setSelection(tGNote != null && tGNote.getEffect().isHammer());
        this.hammer.setEnabled(!bl && tGNote != null);
        this.ghostNote.setSelection(tGNote != null && tGNote.getEffect().isGhostNote());
        this.ghostNote.setEnabled(!bl && tGNote != null);
        this.accentuatedNote.setSelection(tGNote != null && tGNote.getEffect().isAccentuatedNote());
        this.accentuatedNote.setEnabled(!bl && tGNote != null);
        this.heavyAccentuatedNote.setSelection(tGNote != null && tGNote.getEffect().isHeavyAccentuatedNote());
        this.heavyAccentuatedNote.setEnabled(!bl && tGNote != null);
        this.harmonicNote.setSelection(tGNote != null && tGNote.getEffect().isHarmonic());
        this.harmonicNote.setEnabled(!bl && tGNote != null);
        this.graceNote.setSelection(tGNote != null && tGNote.getEffect().isGrace());
        this.graceNote.setEnabled(!bl && tGNote != null);
        this.trill.setSelection(tGNote != null && tGNote.getEffect().isTrill());
        this.trill.setEnabled(!bl && tGNote != null);
        this.tremoloPicking.setSelection(tGNote != null && tGNote.getEffect().isTremoloPicking());
        this.tremoloPicking.setEnabled(!bl && tGNote != null);
        this.palmMute.setSelection(tGNote != null && tGNote.getEffect().isPalmMute());
        this.palmMute.setEnabled(!bl && tGNote != null);
        this.staccato.setSelection(tGNote != null && tGNote.getEffect().isStaccato());
        this.staccato.setEnabled(!bl && tGNote != null);
        this.tapping.setSelection(tGNote != null && tGNote.getEffect().isTapping());
        this.tapping.setEnabled(!bl && tGNote != null);
        this.slapping.setSelection(tGNote != null && tGNote.getEffect().isSlapping());
        this.slapping.setEnabled(!bl && tGNote != null);
        this.popping.setSelection(tGNote != null && tGNote.getEffect().isPopping());
        this.popping.setEnabled(!bl && tGNote != null);
        this.fadeIn.setSelection(tGNote != null && tGNote.getEffect().isFadeIn());
        this.fadeIn.setEnabled(!bl && tGNote != null);
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.noteEffectsMenuItem, "effects", null);
        this.setMenuItemTextAndAccelerator(this.vibrato, "effects.vibrato", "action.note.effect.change-vibrato");
        this.setMenuItemTextAndAccelerator(this.bend, "effects.bend", "action.note.effect.change-bend");
        this.setMenuItemTextAndAccelerator(this.tremoloBar, "effects.tremolo-bar", "action.note.effect.change-tremolo-bar");
        this.setMenuItemTextAndAccelerator(this.deadNote, "effects.deadnote", "action.note.effect.change-dead");
        this.setMenuItemTextAndAccelerator(this.slide, "effects.slide", "action.note.effect.change-slide");
        this.setMenuItemTextAndAccelerator(this.hammer, "effects.hammer", "action.note.effect.change-hammer");
        this.setMenuItemTextAndAccelerator(this.ghostNote, "effects.ghostnote", "action.note.effect.change-ghost");
        this.setMenuItemTextAndAccelerator(this.accentuatedNote, "effects.accentuatednote", "action.note.effect.change-accentuated");
        this.setMenuItemTextAndAccelerator(this.heavyAccentuatedNote, "effects.heavyaccentuatednote", "action.note.effect.change-heavy-accentuated");
        this.setMenuItemTextAndAccelerator(this.harmonicNote, "effects.harmonic", "action.note.effect.change-harmonic");
        this.setMenuItemTextAndAccelerator(this.graceNote, "effects.grace", "action.note.effect.change-grace");
        this.setMenuItemTextAndAccelerator(this.trill, "effects.trill", "action.note.effect.change-trill");
        this.setMenuItemTextAndAccelerator(this.tremoloPicking, "effects.tremolo-picking", "action.note.effect.change-tremolo-picking");
        this.setMenuItemTextAndAccelerator(this.palmMute, "effects.palm-mute", "action.note.effect.change-palm-mute");
        this.setMenuItemTextAndAccelerator(this.staccato, "effects.staccato", "action.note.effect.change-staccato");
        this.setMenuItemTextAndAccelerator(this.tapping, "effects.tapping", "action.note.effect.change-tapping");
        this.setMenuItemTextAndAccelerator(this.slapping, "effects.slapping", "action.note.effect.change-slapping");
        this.setMenuItemTextAndAccelerator(this.popping, "effects.popping", "action.note.effect.change-popping");
        this.setMenuItemTextAndAccelerator(this.fadeIn, "effects.fade-in", "action.note.effect.change-fade-in");
    }

    public void loadIcons() {
    }
}

