/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.edit.EditorKit;
import org.herac.tuxguitar.gui.items.MenuItems;

public class EditMenuItem
extends MenuItems {
    private MenuItem editMenuItem;
    private Menu menu;
    private MenuItem undo;
    private MenuItem redo;
    private MenuItem modeSelection;
    private MenuItem modeEdition;
    private MenuItem notNaturalKey;
    private MenuItem voice1;
    private MenuItem voice2;

    public EditMenuItem(Shell shell, Menu menu, int n) {
        this.editMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.undo = new MenuItem(this.menu, 8);
        this.undo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.undo"));
        this.redo = new MenuItem(this.menu, 8);
        this.redo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.redo"));
        new MenuItem(this.menu, 2);
        this.modeSelection = new MenuItem(this.menu, 16);
        this.modeSelection.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.set-mouse-mode-selection"));
        this.modeEdition = new MenuItem(this.menu, 16);
        this.modeEdition.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.set-mouse-mode-edition"));
        this.notNaturalKey = new MenuItem(this.menu, 32);
        this.notNaturalKey.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.set-natural-key"));
        new MenuItem(this.menu, 2);
        this.voice1 = new MenuItem(this.menu, 16);
        this.voice1.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.voice-1"));
        this.voice2 = new MenuItem(this.menu, 16);
        this.voice2.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.voice-2"));
        this.editMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        EditorKit editorKit = TuxGuitar.instance().getTablatureEditor().getTablature().getEditorKit();
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        this.undo.setEnabled(!bl && TuxGuitar.instance().getUndoableManager().canUndo());
        this.redo.setEnabled(!bl && TuxGuitar.instance().getUndoableManager().canRedo());
        this.modeSelection.setSelection(editorKit.getMouseMode() == 1);
        this.modeSelection.setEnabled(!bl);
        this.modeEdition.setSelection(editorKit.getMouseMode() == 2);
        this.modeEdition.setEnabled(!bl);
        this.notNaturalKey.setSelection(!editorKit.isNatural());
        this.notNaturalKey.setEnabled(!bl && editorKit.getMouseMode() == 2);
        this.voice1.setSelection(editorKit.getTablature().getCaret().getVoice() == 0);
        this.voice2.setSelection(editorKit.getTablature().getCaret().getVoice() == 1);
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.editMenuItem, "edit.menu", null);
        this.setMenuItemTextAndAccelerator(this.undo, "edit.undo", "action.edit.undo");
        this.setMenuItemTextAndAccelerator(this.redo, "edit.redo", "action.edit.redo");
        this.setMenuItemTextAndAccelerator(this.modeSelection, "edit.mouse-mode-selection", "action.edit.set-mouse-mode-selection");
        this.setMenuItemTextAndAccelerator(this.modeEdition, "edit.mouse-mode-edition", "action.edit.set-mouse-mode-edition");
        this.setMenuItemTextAndAccelerator(this.notNaturalKey, "edit.not-natural-key", "action.edit.set-natural-key");
        this.setMenuItemTextAndAccelerator(this.voice1, "edit.voice-1", "action.edit.voice-1");
        this.setMenuItemTextAndAccelerator(this.voice2, "edit.voice-2", "action.edit.voice-2");
    }

    public void loadIcons() {
        this.undo.setImage(TuxGuitar.instance().getIconManager().getEditUndo());
        this.redo.setImage(TuxGuitar.instance().getIconManager().getEditRedo());
    }
}

