/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.TGFileUtils;

public class FileHistory {
    private static final int URL_LIMIT = TuxGuitar.instance().getConfig().getIntConfigValue("history.max-files");
    private boolean changed;
    private boolean newFile;
    private boolean localFile;
    private boolean unsavedFile;
    private List urls = new ArrayList();
    private String chooserPath;

    public FileHistory() {
        this.loadHistory();
        this.reset(null);
    }

    public void reset(URL uRL) {
        this.unsavedFile = false;
        this.newFile = uRL == null;
        this.localFile = uRL != null && this.isLocalFile(uRL);
        this.addURL(uRL);
    }

    public boolean isNewFile() {
        return this.newFile;
    }

    public boolean isLocalFile() {
        return this.localFile;
    }

    public boolean isUnsavedFile() {
        return this.unsavedFile;
    }

    public void setUnsavedFile() {
        this.unsavedFile = true;
    }

    public void setChooserPath(String string) {
        this.chooserPath = string;
    }

    public void setChooserPath(URL uRL) {
        String string = this.getFilePath(uRL);
        if (string != null) {
            this.setChooserPath(string);
        }
    }

    public String getCurrentFileName(String string) {
        URL uRL;
        if (!this.isNewFile() && (uRL = this.getCurrentURL()) != null) {
            return this.decode(new File(uRL.getFile()).getName());
        }
        return string;
    }

    public String getCurrentFilePath() {
        String string;
        URL uRL;
        if (!this.isNewFile() && (uRL = this.getCurrentURL()) != null && (string = this.getFilePath(uRL)) != null) {
            return this.decode(string);
        }
        return this.chooserPath;
    }

    public String getSavePath() {
        String string = this.getCurrentFilePath();
        return string != null ? string : this.chooserPath;
    }

    public String getOpenPath() {
        return this.chooserPath;
    }

    protected String getFilePath(URL uRL) {
        if (this.isLocalFile(uRL)) {
            return new File(uRL.getFile()).getParent();
        }
        return null;
    }

    protected String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return string;
        }
    }

    protected boolean isLocalFile(URL uRL) {
        try {
            if (uRL.getProtocol().equals(new File(uRL.getFile()).toURI().toURL().getProtocol())) {
                return true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    protected URL getCurrentURL() {
        if (!this.urls.isEmpty()) {
            return (URL)this.urls.get(0);
        }
        return null;
    }

    public void addURL(URL uRL) {
        if (uRL != null) {
            this.removeURL(uRL);
            this.urls.add(0, uRL);
            this.checkLimit();
            this.setChanged(true);
        }
        this.saveHistory();
    }

    public List getURLs() {
        return this.urls;
    }

    private void checkLimit() {
        while (this.urls.size() > URL_LIMIT) {
            this.urls.remove(this.urls.size() - 1);
        }
    }

    private void removeURL(URL uRL) {
        for (int i = 0; i < this.urls.size(); ++i) {
            URL uRL2 = (URL)this.urls.get(i);
            if (!uRL2.toString().equals(uRL.toString())) continue;
            this.urls.remove(i);
            break;
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public void loadHistory() {
        try {
            this.urls.clear();
            if (new File(this.getHistoryFileName()).exists()) {
                FileInputStream fileInputStream = new FileInputStream(this.getHistoryFileName());
                Properties properties = new Properties();
                properties.load(fileInputStream);
                this.chooserPath = (String)properties.get("history.path");
                int n = Integer.parseInt((String)properties.get("history.count"));
                for (int i = 0; i < n; ++i) {
                    String string = (String)properties.get("history." + i);
                    if (URL_LIMIT <= i || string == null || string.length() <= 0) continue;
                    this.urls.add(new URL(string));
                }
                this.setChanged(true);
            } else {
                this.saveHistory();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveHistory() {
        try {
            Properties properties = new Properties();
            int n = this.urls.size();
            for (int i = 0; i < n; ++i) {
                properties.put("history." + i, this.urls.get(i).toString());
            }
            properties.put("history.count", Integer.toString(n));
            if (this.chooserPath != null) {
                properties.put("history.path", this.chooserPath);
            }
            properties.store(new FileOutputStream(this.getHistoryFileName()), "History Files");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String getHistoryFileName() {
        return TGFileUtils.PATH_USER_CONFIG + File.separator + "history.properties";
    }
}

